/******************************************************
 *                                                    *
 * FPAC project.            FPAC PAD                  *
 *                                                    *
 * Parts of code from different sources of ax25-utils *
 *                                                    *
 * F6FBB 05-1997                                      *
 *                                                    *
 ******************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <syslog.h>
#include <ctype.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <arpa/inet.h>

#include <linux/socket.h>
#include <linux/netdevice.h>
#include <linux/if.h>
#include <linux/if_arp.h>
#include <linux/sockios.h>

#include <linux/ax25.h>
#include <linux/rose.h>

#include "node.h"
#include "io.h"
#include "axutils.h"
#include "axconfig.h"

#define FPACCONF "/etc/ax25/fpac.conf"

enum conf_kw
{
	CALLSIGN,
	COMMAND,
	PATH,
	ALTERNATE,
	DNIC,
	ADDRESS,
	COVERAGE,
	NODE,
	ROUTES,
	PORT,
	LUSER,
	USERPORT,
	DEFPORT,
	ADDPORT,
	ALIAS,
	PASSWORD,
	SYSOP,
	APPLICATION,
	END
};

typedef struct
{
	char keyword[20];
	int  ident;
} kw_t;

kw_t kw[] = 
{
	{ "callsign", CALLSIGN },
	{ "command", COMMAND },
	{ "path", PATH },
	{ "alternate", ALTERNATE },
	{ "dnic", DNIC },
	{ "address", ADDRESS },
	{ "coverage", COVERAGE },
	{ "node", NODE },
	{ "routes", ROUTES },
	{ "port", PORT },
	{ "user", LUSER },
	{ "userport", USERPORT },
	{ "defport", DEFPORT },
	{ "addport", ADDPORT },
	{ "alias", ALIAS },
	{ "password", PASSWORD },
	{ "sysop", SYSOP },
	{ "application", APPLICATION },
	{ "end", END },
	{ "", -1}	/* End of the table */
};


/* Return a keyword identifier or -1 if not found */
static int kwid(char *keyword)
{
	int i;

	for (i = 0 ; kw[i].keyword[0] ; i++)
	{
		if (strcasecmp(keyword, kw[i].keyword) ==0)
			break;
	}
	return(kw[i].ident);
}

/* Cleans the beginning and the end of a string */
static char *strclean(char *str)
{
	int len;

	while (isspace(*str))
		++str;

	len = strlen(str);

	while ((len > 0) && (!isgraph(str[len-1])))
	{
		str[len-1] = '\0';
		--len;
	}

	return(str);
}

/* Returns the keyword and the value */
static int get_value(char *line, char *keyword, char *value)
{
	char *ptr;

	*keyword = *value = '\0';

	line = strclean(line);
	if ((*line == '\0') || (*line == '#'))
		return(0);

	ptr = strchr(line, '=');
	if (ptr)
	{
		*ptr++ = '\0';
		strcpy(value, strclean(ptr));
	}

	strcpy(keyword, strclean(line));

	return(1);	
}

static void strcpy_n(char *rec, char *src, int len)
{
	memset(rec, '\0', len);
	strncpy(rec, src, len-1);
}

int read_conf(int verbose)
{
	int mode = 0;
	FILE *fptr;
	char *ptr;
	char line[80];
	char keyword[80];
	char mycall[10];
	char value[256];
	char dnic_cur[5];

	alias_t *a = NULL;
	alias_head = NULL;

	mycall[0] = '\0';

	fptr = fopen(FPACCONF, "r");
	if (fptr == NULL)
	{
		syslog(LOG_ERR, "Cannot open file %s\n", FPACCONF);
		return(0);
	}

	while (fgets(line, sizeof(line), fptr))
	{

		if (!get_value(line, keyword, value))
			continue;

		switch (mode)
		{
		case COMMAND :
			switch(kwid(keyword))
			{
			case END:
				mode = 0;
				break;
			default:
				/* New command */
				add_alias_cmd(&Nodecmds, keyword, value);
				break;
			}
			break;
		case SYSOP :
			switch(kwid(keyword))
			{
			case END:
				mode = 0;
				break;
			default:
				/* New command */
				add_alias_cmd(&Syscmds, keyword, value);
				break;
			}
			break;
		case NODE:
			switch(kwid(keyword))
			{
			case END:
				mode = 0;
				break;
			}
		case ADDPORT:
			switch(kwid(keyword))
			{
			case END:
				mode = 0;
				break;
			}
			break;
		case APPLICATION:
			switch(kwid(keyword))
			{
			case END:
				mode = 0;
				break;
			}
			break;
		case LUSER:
			switch(kwid(keyword))
			{
			case END:
				mode = 0;
				break;
			}
			break;
		case ROUTES:
			switch(kwid(keyword))
			{
			case END:
				mode = 0;
				break;
			}
			break;
		case ALIAS:
			switch(kwid(keyword))
			{
			case PATH:
				ptr = value;
				while (*ptr)
				{
					if (*ptr == ',')
						*ptr = ' ';
					++ptr;
				}
				strcpy_n(a->path, value, sizeof(a->path));
				break;
			case END:
				a->next = alias_head;
				alias_head = a;
				mode = 0;
				break;
			}
			break;
		default:
			switch(kwid(keyword))
			{
			case PASSWORD:
				strcpy_n(fpac_pass, value, sizeof(fpac_pass));
				break;
			case CALLSIGN:
				strcpy_n(fpac_call, value, sizeof(fpac_call));
				strcpy(mycall, fpac_call);
				ptr = strchr(mycall, '-');
				if (ptr)
					*ptr = '\0';
				break;
			case ALTERNATE:
				strcpy_n(fpac_digi, value, sizeof(fpac_digi));
				break;
			case DNIC:
				strcpy_n(fpac_dnic, value, sizeof(fpac_dnic));
				break;
			case ADDRESS:
				strcpy_n(fpac_addr, value, sizeof(fpac_addr));
				break;
			case COVERAGE:
				strcpy_n(fpac_cover, value, sizeof(fpac_cover));
				break;
			case DEFPORT:
				strcpy_n(def_port, value, sizeof(def_port));
				break;
			case USERPORT:
				strcpy_n(ax25_port, value, sizeof(ax25_port));
				break;
			case NODE:
				mode = NODE;
				break;
			case LUSER:
				mode = LUSER;
				break;
			case ADDPORT:
				mode = ADDPORT;
				break;
			case ALIAS:
				a = calloc(1, sizeof(alias_t));
				a->fd = -1;
				strcpy_n(a->alias, value, 9);
				mode = ALIAS;
				break;
			case COMMAND:
				mode = COMMAND;
				break;
			case APPLICATION:
				mode = APPLICATION;
				break;
			case SYSOP:
				mode = SYSOP;
				break;
			case ROUTES:
				strcpy(dnic_cur, fpac_dnic);
				mode = ROUTES;
				break;
			}
			break;
		}

	}
	return(1);
}
