/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile.bcfile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.spi.file.rfile.compression.CompressionAlgorithmConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionAlgorithm
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionAlgorithm.class);
    private static final LoadingCache<Map.Entry<CompressionAlgorithm, Integer>, CompressionCodec> codecCache = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Map.Entry<CompressionAlgorithm, Integer>, CompressionCodec>(){

        public CompressionCodec load(Map.Entry<CompressionAlgorithm, Integer> key) {
            return key.getKey().createNewCodec(key.getValue());
        }
    });
    protected static final int DATA_IBUF_SIZE = 1024;
    protected static final int DATA_OBUF_SIZE = 4096;
    private final CompressionAlgorithmConfiguration algorithm;
    private final AtomicBoolean checked = new AtomicBoolean(false);
    private transient CompressionCodec codec = null;

    public CompressionAlgorithm(CompressionAlgorithmConfiguration algorithm, Configuration conf) {
        this.algorithm = algorithm;
        this.setConf(conf);
        this.codec = this.initCodec(this.checked, algorithm.getDefaultBufferSize(), this.codec);
    }

    CompressionCodec createNewCodec(int bufferSize) {
        return this.createNewCodec(this.algorithm.getCodecClassNameProperty(), this.algorithm.getCodecClassName(), bufferSize, this.algorithm.getBufferSizeProperty());
    }

    public InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
        if (!this.isSupported()) {
            throw new IOException("codec class not specified. Did you forget to set property " + this.algorithm.getCodecClassNameProperty() + "?");
        }
        if (this.algorithm.cacheCodecsWithNonDefaultSizes()) {
            return this.createDecompressionStream(downStream, decompressor, downStreamBufferSize, this.algorithm.getDefaultBufferSize(), this, this.codec);
        }
        InputStream bis = this.bufferStream(downStream, downStreamBufferSize);
        CompressionInputStream cis = this.codec.createInputStream(bis, decompressor);
        return new BufferedInputStream((InputStream)cis, 1024);
    }

    private InputStream createDecompressionStream(InputStream stream, Decompressor decompressor, int bufferSize, int defaultBufferSize, CompressionAlgorithm algorithm, CompressionCodec codec) throws IOException {
        if (bufferSize != defaultBufferSize) {
            Map.Entry sizeOpt = Maps.immutableEntry((Object)((Object)algorithm), (Object)bufferSize);
            try {
                codec = (CompressionCodec)codecCache.get((Object)sizeOpt);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        CompressionInputStream cis = codec.createInputStream(stream, decompressor);
        return new BufferedInputStream((InputStream)cis, 1024);
    }

    public OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
        if (!this.isSupported()) {
            throw new IOException("codec class not specified. Did you forget to set property " + this.algorithm.getCodecClassNameProperty() + "?");
        }
        return this.createFinishedOnFlushCompressionStream(downStream, compressor, downStreamBufferSize);
    }

    boolean isSupported() {
        return this.codec != null;
    }

    CompressionCodec getCodec() {
        return this.codec;
    }

    public Compressor getCompressor() {
        CompressionCodec codec = this.getCodec();
        if (codec != null) {
            Compressor compressor = CodecPool.getCompressor((CompressionCodec)codec);
            if (compressor != null) {
                if (compressor.finished()) {
                    LOG.warn("Compressor obtained from CodecPool already finished()");
                } else {
                    LOG.trace("Got a compressor: {}", (Object)compressor.hashCode());
                }
                compressor.reset();
            }
            return compressor;
        }
        return null;
    }

    public void returnCompressor(Compressor compressor) {
        if (compressor != null) {
            LOG.trace("Return a compressor: {}", (Object)compressor.hashCode());
            CodecPool.returnCompressor((Compressor)compressor);
        }
    }

    public Decompressor getDecompressor() {
        CompressionCodec codec = this.getCodec();
        if (codec != null) {
            Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
            if (decompressor != null) {
                if (decompressor.finished()) {
                    LOG.warn("Decompressor obtained from CodecPool already finished()");
                } else {
                    LOG.trace("Got a decompressor: {}", (Object)decompressor.hashCode());
                }
                decompressor.reset();
            }
            return decompressor;
        }
        return null;
    }

    public void returnDecompressor(Decompressor decompressor) {
        if (decompressor != null) {
            LOG.trace("Returned a decompressor: {}", (Object)decompressor.hashCode());
            CodecPool.returnDecompressor((Decompressor)decompressor);
        }
    }

    public String getName() {
        return this.algorithm.getName();
    }

    private CompressionCodec initCodec(AtomicBoolean checked, int bufferSize, CompressionCodec originalCodec) {
        if (!checked.get()) {
            checked.set(true);
            return this.createNewCodec(bufferSize);
        }
        return originalCodec;
    }

    private CompressionCodec createNewCodec(String codecClazzProp, String defaultClazz, int bufferSize, String bufferSizeConfigOpt) {
        String clazz = defaultClazz;
        if (codecClazzProp != null) {
            clazz = System.getProperty(codecClazzProp, this.getConf().get(codecClazzProp, defaultClazz));
        }
        try {
            LOG.info("Trying to load codec class {}", (Object)clazz);
            Configuration config = new Configuration(this.getConf());
            this.updateBuffer(config, bufferSizeConfigOpt, bufferSize);
            return (CompressionCodec)ReflectionUtils.newInstance(Class.forName(clazz), (Configuration)config);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("ClassNotFoundException creating codec class {} for {}. Enable trace logging for stacktrace.", (Object)clazz, (Object)codecClazzProp);
            LOG.trace("Unable to load codec class due to ", (Throwable)e);
            return null;
        }
    }

    private OutputStream createFinishedOnFlushCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
        OutputStream out = this.bufferStream(downStream, downStreamBufferSize);
        CompressionOutputStream cos = this.getCodec().createOutputStream(out, compressor);
        return new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
    }

    private OutputStream bufferStream(OutputStream stream, int bufferSize) {
        if (bufferSize > 0) {
            return new BufferedOutputStream(stream, bufferSize);
        }
        return stream;
    }

    private InputStream bufferStream(InputStream stream, int bufferSize) {
        if (bufferSize > 0) {
            return new BufferedInputStream(stream, bufferSize);
        }
        return stream;
    }

    private void updateBuffer(Configuration config, String bufferSizeOpt, int bufferSize) {
        if (bufferSize > 0) {
            config.setInt(bufferSizeOpt, bufferSize);
        }
    }

    public static class FinishOnFlushCompressionStream
    extends FilterOutputStream {
        FinishOnFlushCompressionStream(CompressionOutputStream cout) {
            super((OutputStream)cout);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            CompressionOutputStream cout = (CompressionOutputStream)this.out;
            cout.finish();
            cout.flush();
            cout.resetState();
        }
    }
}

