/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.logging;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.CacheEntry;
import org.apache.accumulo.core.spi.cache.CacheType;
import org.apache.accumulo.core.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBlockCache
implements BlockCache {
    private final BlockCache blockCache;
    private static final Logger log = LoggerFactory.getLogger((String)"org.apache.accumulo.cache");
    private final CacheType type;

    private LoggingBlockCache(CacheType type, BlockCache blockCache) {
        this.type = type;
        this.blockCache = blockCache;
    }

    private static String toString(CacheEntry ce) {
        return ce == null ? null : ce.getBuffer().length + " bytes";
    }

    @Override
    public CacheEntry cacheBlock(String blockName, byte[] buf) {
        Timer timer = Timer.startNew();
        CacheEntry ce = this.blockCache.cacheBlock(blockName, buf);
        long elapsed = timer.elapsed(TimeUnit.MICROSECONDS);
        log.trace("{} cacheBlock({},{} bytes) returned {} in {}\u03bcs", new Object[]{this.type, blockName, buf.length, LoggingBlockCache.toString(ce), elapsed});
        return ce;
    }

    @Override
    public CacheEntry getBlock(String blockName) {
        Timer timer = Timer.startNew();
        CacheEntry ce = this.blockCache.getBlock(blockName);
        long elapsed = timer.elapsed(TimeUnit.MICROSECONDS);
        log.trace("{} getBlock({}) returned {} in {}\u03bcs", new Object[]{this.type, blockName, LoggingBlockCache.toString(ce), elapsed});
        return ce;
    }

    @Override
    public CacheEntry getBlock(String blockName, BlockCache.Loader loader) {
        Timer timer = Timer.startNew();
        CacheEntry ce = this.blockCache.getBlock(blockName, new LoggingLoader(loader));
        long elapsed = timer.elapsed(TimeUnit.MICROSECONDS);
        log.trace("{} getBlock({}, loader:{}) returned {} in {}\u03bcs", new Object[]{this.type, blockName, loader.hashCode(), LoggingBlockCache.toString(ce), elapsed});
        return ce;
    }

    @Override
    public long getMaxHeapSize() {
        return this.blockCache.getMaxHeapSize();
    }

    @Override
    public long getMaxSize() {
        return this.blockCache.getMaxSize();
    }

    @Override
    public BlockCache.Stats getStats() {
        return this.blockCache.getStats();
    }

    public static BlockCache wrap(CacheType type, BlockCache blockCache) {
        if (blockCache != null && log.isTraceEnabled() && !(blockCache instanceof LoggingBlockCache)) {
            return new LoggingBlockCache(type, blockCache);
        }
        return blockCache;
    }

    private final class LoggingLoader
    implements BlockCache.Loader {
        private final BlockCache.Loader loader;

        private LoggingLoader(BlockCache.Loader loader) {
            this.loader = loader;
        }

        @Override
        public Map<String, BlockCache.Loader> getDependencies() {
            Map<String, BlockCache.Loader> deps = this.loader.getDependencies();
            log.trace("{} loader:{} getDependencies() returned {}", new Object[]{LoggingBlockCache.this.type, this.loader.hashCode(), deps.keySet()});
            return Maps.transformValues(deps, secondLoader -> new LoggingLoader((BlockCache.Loader)secondLoader));
        }

        @Override
        public byte[] load(int maxSize, Map<String, byte[]> dependencies) {
            Timer timer = Timer.startNew();
            byte[] data = this.loader.load(maxSize, dependencies);
            long elapsed = timer.elapsed(TimeUnit.MICROSECONDS);
            Map logDeps = Maps.transformValues(dependencies, bytes -> bytes == null ? null : Integer.valueOf(((byte[])bytes).length));
            log.trace("{} loader:{} load({},{}) returned {} in {}\u03bcs", new Object[]{LoggingBlockCache.this.type, this.loader.hashCode(), maxSize, logDeps, data == null ? null : data.length + " bytes", elapsed});
            return data;
        }
    }
}

