/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ExportTableCommand
extends Shell.Command {
    private Option tableOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        shellState.getAccumuloClient().tableOperations().exportTable(tableName, cl.getArgs()[0]);
        return 0;
    }

    @Override
    public String usage() {
        return this.getName() + " <export dir>";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.tableOpt = new Option("t", "table", true, "table to export");
        this.tableOpt.setArgName("table");
        o.addOption(this.tableOpt);
        return o;
    }

    @Override
    public String description() {
        return "exports a table";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForTables(root, completionSet);
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

