/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Expose SOAP WebServices using Apache CXF or connect to external WebServices
 * using CXF WS client.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CxfEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the CXF component.
     */
    public interface CxfEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCxfEndpointConsumerBuilder advanced() {
            return (AdvancedCxfEndpointConsumerBuilder) this;
        }
        /**
         * The data type messages supported by the CXF endpoint.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.common.DataFormat</code> type.
         * 
         * Default: POJO
         * Group: common
         * 
         * @param dataFormat the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder dataFormat(org.apache.camel.component.cxf.common.DataFormat dataFormat) {
            doSetProperty("dataFormat", dataFormat);
            return this;
        }
        /**
         * The data type messages supported by the CXF endpoint.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.common.DataFormat</code> type.
         * 
         * Default: POJO
         * Group: common
         * 
         * @param dataFormat the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder dataFormat(String dataFormat) {
            doSetProperty("dataFormat", dataFormat);
            return this;
        }
        /**
         * The WSDL style that describes how parameters are represented in the
         * SOAP body. If the value is false, CXF will chose the document-literal
         * unwrapped style, If the value is true, CXF will chose the
         * document-literal wrapped style.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         * 
         * @param wrappedStyle the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder wrappedStyle(Boolean wrappedStyle) {
            doSetProperty("wrappedStyle", wrappedStyle);
            return this;
        }
        /**
         * The WSDL style that describes how parameters are represented in the
         * SOAP body. If the value is false, CXF will chose the document-literal
         * unwrapped style, If the value is true, CXF will chose the
         * document-literal wrapped style.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         * 
         * @param wrappedStyle the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder wrappedStyle(String wrappedStyle) {
            doSetProperty("wrappedStyle", wrappedStyle);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound SOAP messages to log.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param loggingFeatureEnabled the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder loggingFeatureEnabled(boolean loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound SOAP messages to log.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param loggingFeatureEnabled the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder loggingFeatureEnabled(String loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled and -1 for no limit.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 49152
         * Group: logging
         * 
         * @param loggingSizeLimit the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder loggingSizeLimit(int loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled and -1 for no limit.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 49152
         * Group: logging
         * 
         * @param loggingSizeLimit the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder loggingSizeLimit(String loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param skipFaultLogging the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder skipFaultLogging(boolean skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param skipFaultLogging the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder skipFaultLogging(String skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option is used to set the basic authentication information of
         * password for the CXF client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * This option is used to set the basic authentication information of
         * username for the CXF client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * The bindingId for the service model to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param bindingId the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder bindingId(String bindingId) {
            doSetProperty("bindingId", bindingId);
            return this;
        }
        /**
         * The endpoint name this service is implementing, it maps to the
         * wsdl:portname. In the format of ns:PORT_NAME where ns is a namespace
         * prefix valid at this scope.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param portName the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder portName(String portName) {
            doSetProperty("portName", portName);
            return this;
        }
        /**
         * This option can override the endpointUrl that published from the WSDL
         * which can be accessed with service address url plus wsd.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param publishedEndpointUrl the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder publishedEndpointUrl(String publishedEndpointUrl) {
            doSetProperty("publishedEndpointUrl", publishedEndpointUrl);
            return this;
        }
        /**
         * The class name of the SEI (Service Endpoint Interface) class which
         * could have JSR181 annotation or not.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: service
         * 
         * @param serviceClass the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder serviceClass(Class<java.lang.Object> serviceClass) {
            doSetProperty("serviceClass", serviceClass);
            return this;
        }
        /**
         * The class name of the SEI (Service Endpoint Interface) class which
         * could have JSR181 annotation or not.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: service
         * 
         * @param serviceClass the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder serviceClass(String serviceClass) {
            doSetProperty("serviceClass", serviceClass);
            return this;
        }
        /**
         * The service name this service is implementing, it maps to the
         * wsdl:servicename.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param serviceName the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder serviceName(String serviceName) {
            doSetProperty("serviceName", serviceName);
            return this;
        }
        /**
         * The location of the WSDL. Can be on the classpath, file system, or be
         * hosted remotely.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param wsdlURL the value to set
         * @return the dsl builder
         */
        default CxfEndpointConsumerBuilder wsdlURL(String wsdlURL) {
            doSetProperty("wsdlURL", wsdlURL);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the CXF component.
     */
    public interface AdvancedCxfEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CxfEndpointConsumerBuilder basic() {
            return (CxfEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * This option controls whether the CXF component, when running in
         * PAYLOAD mode, will DOM parse the incoming messages into DOM Elements
         * or keep the payload as a javax.xml.transform.Source object that would
         * allow streaming in some cases.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         * 
         * @param allowStreaming the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder allowStreaming(Boolean allowStreaming) {
            doSetProperty("allowStreaming", allowStreaming);
            return this;
        }
        /**
         * This option controls whether the CXF component, when running in
         * PAYLOAD mode, will DOM parse the incoming messages into DOM Elements
         * or keep the payload as a javax.xml.transform.Source object that would
         * allow streaming in some cases.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param allowStreaming the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder allowStreaming(String allowStreaming) {
            doSetProperty("allowStreaming", allowStreaming);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option is a: <code>org.apache.cxf.Bus</code> type.
         * 
         * Group: advanced
         * 
         * @param bus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder bus(org.apache.cxf.Bus bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option will be converted to a <code>org.apache.cxf.Bus</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param bus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder bus(String bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param continuationTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder continuationTimeout(long continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param continuationTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder continuationTimeout(String continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.common.CxfBinding</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfBinding the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder cxfBinding(org.apache.camel.component.cxf.common.CxfBinding cxfBinding) {
            doSetProperty("cxfBinding", cxfBinding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.common.CxfBinding</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfBinding the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder cxfBinding(String cxfBinding) {
            doSetProperty("cxfBinding", cxfBinding);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.CxfEndpointConfigurer which supports
         * to configure the CXF endpoint in programmatic way. User can configure
         * the CXF server and client by implementing configure{ServerClient}
         * method of CxfEndpointConfigurer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxws.CxfConfigurer</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfConfigurer the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder cxfConfigurer(org.apache.camel.component.cxf.jaxws.CxfConfigurer cxfConfigurer) {
            doSetProperty("cxfConfigurer", cxfConfigurer);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.CxfEndpointConfigurer which supports
         * to configure the CXF endpoint in programmatic way. User can configure
         * the CXF server and client by implementing configure{ServerClient}
         * method of CxfEndpointConfigurer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxws.CxfConfigurer</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfConfigurer the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder cxfConfigurer(String cxfConfigurer) {
            doSetProperty("cxfConfigurer", cxfConfigurer);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param defaultBus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder defaultBus(boolean defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param defaultBus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder defaultBus(String defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to merge protocol headers. If enabled then propagating
         * headers between Camel and CXF becomes more consistent and similar.
         * For more details see CAMEL-6393.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mergeProtocolHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder mergeProtocolHeaders(boolean mergeProtocolHeaders) {
            doSetProperty("mergeProtocolHeaders", mergeProtocolHeaders);
            return this;
        }
        /**
         * Whether to merge protocol headers. If enabled then propagating
         * headers between Camel and CXF becomes more consistent and similar.
         * For more details see CAMEL-6393.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mergeProtocolHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder mergeProtocolHeaders(String mergeProtocolHeaders) {
            doSetProperty("mergeProtocolHeaders", mergeProtocolHeaders);
            return this;
        }
        /**
         * To enable MTOM (attachments). This requires to use POJO or PAYLOAD
         * data format mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mtomEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder mtomEnabled(boolean mtomEnabled) {
            doSetProperty("mtomEnabled", mtomEnabled);
            return this;
        }
        /**
         * To enable MTOM (attachments). This requires to use POJO or PAYLOAD
         * data format mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mtomEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder mtomEnabled(String mtomEnabled) {
            doSetProperty("mtomEnabled", mtomEnabled);
            return this;
        }
        /**
         * To set additional CXF options using the key/value pairs from the Map.
         * For example to turn on stacktraces in SOAP faults,
         * properties.faultStackTraceEnabled=true.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the properties(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder properties(String key, Object value) {
            doSetMultiValueProperty("properties", "properties." + key, value);
            return this;
        }
        /**
         * To set additional CXF options using the key/value pairs from the Map.
         * For example to turn on stacktraces in SOAP faults,
         * properties.faultStackTraceEnabled=true.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the properties(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder properties(Map values) {
            doSetMultiValueProperties("properties", "properties.", values);
            return this;
        }
        /**
         * Enable schema validation for request and response. Disabled by
         * default for performance reason.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param schemaValidationEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder schemaValidationEnabled(Boolean schemaValidationEnabled) {
            doSetProperty("schemaValidationEnabled", schemaValidationEnabled);
            return this;
        }
        /**
         * Enable schema validation for request and response. Disabled by
         * default for performance reason.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param schemaValidationEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder schemaValidationEnabled(String schemaValidationEnabled) {
            doSetProperty("schemaValidationEnabled", schemaValidationEnabled);
            return this;
        }
        /**
         * Sets whether SOAP message validation should be disabled.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param skipPayloadMessagePartCheck the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder skipPayloadMessagePartCheck(boolean skipPayloadMessagePartCheck) {
            doSetProperty("skipPayloadMessagePartCheck", skipPayloadMessagePartCheck);
            return this;
        }
        /**
         * Sets whether SOAP message validation should be disabled.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param skipPayloadMessagePartCheck the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointConsumerBuilder skipPayloadMessagePartCheck(String skipPayloadMessagePartCheck) {
            doSetProperty("skipPayloadMessagePartCheck", skipPayloadMessagePartCheck);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the CXF component.
     */
    public interface CxfEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCxfEndpointProducerBuilder advanced() {
            return (AdvancedCxfEndpointProducerBuilder) this;
        }

        /**
         * The data type messages supported by the CXF endpoint.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.common.DataFormat</code> type.
         * 
         * Default: POJO
         * Group: common
         * 
         * @param dataFormat the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder dataFormat(org.apache.camel.component.cxf.common.DataFormat dataFormat) {
            doSetProperty("dataFormat", dataFormat);
            return this;
        }
        /**
         * The data type messages supported by the CXF endpoint.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.common.DataFormat</code> type.
         * 
         * Default: POJO
         * Group: common
         * 
         * @param dataFormat the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder dataFormat(String dataFormat) {
            doSetProperty("dataFormat", dataFormat);
            return this;
        }
        /**
         * The WSDL style that describes how parameters are represented in the
         * SOAP body. If the value is false, CXF will chose the document-literal
         * unwrapped style, If the value is true, CXF will chose the
         * document-literal wrapped style.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         * 
         * @param wrappedStyle the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder wrappedStyle(Boolean wrappedStyle) {
            doSetProperty("wrappedStyle", wrappedStyle);
            return this;
        }
        /**
         * The WSDL style that describes how parameters are represented in the
         * SOAP body. If the value is false, CXF will chose the document-literal
         * unwrapped style, If the value is true, CXF will chose the
         * document-literal wrapped style.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         * 
         * @param wrappedStyle the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder wrappedStyle(String wrappedStyle) {
            doSetProperty("wrappedStyle", wrappedStyle);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer
         * 
         * @param cookieHandler the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder cookieHandler(org.apache.camel.http.base.cookie.CookieHandler cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer
         * 
         * @param cookieHandler the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder cookieHandler(String cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * This option will set the default operationName that will be used by
         * the CxfProducer which invokes the remote service.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param defaultOperationName the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder defaultOperationName(String defaultOperationName) {
            doSetProperty("defaultOperationName", defaultOperationName);
            return this;
        }
        /**
         * This option will set the default operationNamespace that will be used
         * by the CxfProducer which invokes the remote service.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param defaultOperationNamespace the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder defaultOperationNamespace(String defaultOperationNamespace) {
            doSetProperty("defaultOperationNamespace", defaultOperationNamespace);
            return this;
        }
        /**
         * The hostname verifier to be used. Use the # notation to reference a
         * HostnameVerifier from the registry.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: producer
         * 
         * @param hostnameVerifier the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder hostnameVerifier(javax.net.ssl.HostnameVerifier hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * The hostname verifier to be used. Use the # notation to reference a
         * HostnameVerifier from the registry.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: producer
         * 
         * @param hostnameVerifier the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder hostnameVerifier(String hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * The Camel SSL setting reference. Use the # notation to reference the
         * SSL Context.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: producer
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The Camel SSL setting reference. Use the # notation to reference the
         * SSL Context.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: producer
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Which kind of operation that CXF endpoint producer will invoke.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param wrapped the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder wrapped(boolean wrapped) {
            doSetProperty("wrapped", wrapped);
            return this;
        }
        /**
         * Which kind of operation that CXF endpoint producer will invoke.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param wrapped the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder wrapped(String wrapped) {
            doSetProperty("wrapped", wrapped);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound SOAP messages to log.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param loggingFeatureEnabled the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder loggingFeatureEnabled(boolean loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound SOAP messages to log.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param loggingFeatureEnabled the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder loggingFeatureEnabled(String loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled and -1 for no limit.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 49152
         * Group: logging
         * 
         * @param loggingSizeLimit the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder loggingSizeLimit(int loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled and -1 for no limit.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 49152
         * Group: logging
         * 
         * @param loggingSizeLimit the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder loggingSizeLimit(String loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param skipFaultLogging the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder skipFaultLogging(boolean skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param skipFaultLogging the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder skipFaultLogging(String skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option is used to set the basic authentication information of
         * password for the CXF client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * This option is used to set the basic authentication information of
         * username for the CXF client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * The bindingId for the service model to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param bindingId the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder bindingId(String bindingId) {
            doSetProperty("bindingId", bindingId);
            return this;
        }
        /**
         * The endpoint name this service is implementing, it maps to the
         * wsdl:portname. In the format of ns:PORT_NAME where ns is a namespace
         * prefix valid at this scope.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param portName the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder portName(String portName) {
            doSetProperty("portName", portName);
            return this;
        }
        /**
         * This option can override the endpointUrl that published from the WSDL
         * which can be accessed with service address url plus wsd.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param publishedEndpointUrl the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder publishedEndpointUrl(String publishedEndpointUrl) {
            doSetProperty("publishedEndpointUrl", publishedEndpointUrl);
            return this;
        }
        /**
         * The class name of the SEI (Service Endpoint Interface) class which
         * could have JSR181 annotation or not.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: service
         * 
         * @param serviceClass the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder serviceClass(Class<java.lang.Object> serviceClass) {
            doSetProperty("serviceClass", serviceClass);
            return this;
        }
        /**
         * The class name of the SEI (Service Endpoint Interface) class which
         * could have JSR181 annotation or not.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: service
         * 
         * @param serviceClass the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder serviceClass(String serviceClass) {
            doSetProperty("serviceClass", serviceClass);
            return this;
        }
        /**
         * The service name this service is implementing, it maps to the
         * wsdl:servicename.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param serviceName the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder serviceName(String serviceName) {
            doSetProperty("serviceName", serviceName);
            return this;
        }
        /**
         * The location of the WSDL. Can be on the classpath, file system, or be
         * hosted remotely.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param wsdlURL the value to set
         * @return the dsl builder
         */
        default CxfEndpointProducerBuilder wsdlURL(String wsdlURL) {
            doSetProperty("wsdlURL", wsdlURL);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the CXF component.
     */
    public interface AdvancedCxfEndpointProducerBuilder extends EndpointProducerBuilder {
        default CxfEndpointProducerBuilder basic() {
            return (CxfEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * This option controls whether the CXF component, when running in
         * PAYLOAD mode, will DOM parse the incoming messages into DOM Elements
         * or keep the payload as a javax.xml.transform.Source object that would
         * allow streaming in some cases.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         * 
         * @param allowStreaming the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder allowStreaming(Boolean allowStreaming) {
            doSetProperty("allowStreaming", allowStreaming);
            return this;
        }
        /**
         * This option controls whether the CXF component, when running in
         * PAYLOAD mode, will DOM parse the incoming messages into DOM Elements
         * or keep the payload as a javax.xml.transform.Source object that would
         * allow streaming in some cases.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param allowStreaming the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder allowStreaming(String allowStreaming) {
            doSetProperty("allowStreaming", allowStreaming);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option is a: <code>org.apache.cxf.Bus</code> type.
         * 
         * Group: advanced
         * 
         * @param bus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder bus(org.apache.cxf.Bus bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option will be converted to a <code>org.apache.cxf.Bus</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param bus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder bus(String bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param continuationTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder continuationTimeout(long continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param continuationTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder continuationTimeout(String continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.common.CxfBinding</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfBinding the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder cxfBinding(org.apache.camel.component.cxf.common.CxfBinding cxfBinding) {
            doSetProperty("cxfBinding", cxfBinding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.common.CxfBinding</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfBinding the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder cxfBinding(String cxfBinding) {
            doSetProperty("cxfBinding", cxfBinding);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.CxfEndpointConfigurer which supports
         * to configure the CXF endpoint in programmatic way. User can configure
         * the CXF server and client by implementing configure{ServerClient}
         * method of CxfEndpointConfigurer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxws.CxfConfigurer</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfConfigurer the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder cxfConfigurer(org.apache.camel.component.cxf.jaxws.CxfConfigurer cxfConfigurer) {
            doSetProperty("cxfConfigurer", cxfConfigurer);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.CxfEndpointConfigurer which supports
         * to configure the CXF endpoint in programmatic way. User can configure
         * the CXF server and client by implementing configure{ServerClient}
         * method of CxfEndpointConfigurer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxws.CxfConfigurer</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfConfigurer the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder cxfConfigurer(String cxfConfigurer) {
            doSetProperty("cxfConfigurer", cxfConfigurer);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param defaultBus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder defaultBus(boolean defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param defaultBus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder defaultBus(String defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to merge protocol headers. If enabled then propagating
         * headers between Camel and CXF becomes more consistent and similar.
         * For more details see CAMEL-6393.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mergeProtocolHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder mergeProtocolHeaders(boolean mergeProtocolHeaders) {
            doSetProperty("mergeProtocolHeaders", mergeProtocolHeaders);
            return this;
        }
        /**
         * Whether to merge protocol headers. If enabled then propagating
         * headers between Camel and CXF becomes more consistent and similar.
         * For more details see CAMEL-6393.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mergeProtocolHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder mergeProtocolHeaders(String mergeProtocolHeaders) {
            doSetProperty("mergeProtocolHeaders", mergeProtocolHeaders);
            return this;
        }
        /**
         * To enable MTOM (attachments). This requires to use POJO or PAYLOAD
         * data format mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mtomEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder mtomEnabled(boolean mtomEnabled) {
            doSetProperty("mtomEnabled", mtomEnabled);
            return this;
        }
        /**
         * To enable MTOM (attachments). This requires to use POJO or PAYLOAD
         * data format mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mtomEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder mtomEnabled(String mtomEnabled) {
            doSetProperty("mtomEnabled", mtomEnabled);
            return this;
        }
        /**
         * To set additional CXF options using the key/value pairs from the Map.
         * For example to turn on stacktraces in SOAP faults,
         * properties.faultStackTraceEnabled=true.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the properties(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder properties(String key, Object value) {
            doSetMultiValueProperty("properties", "properties." + key, value);
            return this;
        }
        /**
         * To set additional CXF options using the key/value pairs from the Map.
         * For example to turn on stacktraces in SOAP faults,
         * properties.faultStackTraceEnabled=true.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the properties(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder properties(Map values) {
            doSetMultiValueProperties("properties", "properties.", values);
            return this;
        }
        /**
         * Enable schema validation for request and response. Disabled by
         * default for performance reason.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param schemaValidationEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder schemaValidationEnabled(Boolean schemaValidationEnabled) {
            doSetProperty("schemaValidationEnabled", schemaValidationEnabled);
            return this;
        }
        /**
         * Enable schema validation for request and response. Disabled by
         * default for performance reason.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param schemaValidationEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder schemaValidationEnabled(String schemaValidationEnabled) {
            doSetProperty("schemaValidationEnabled", schemaValidationEnabled);
            return this;
        }
        /**
         * Sets whether SOAP message validation should be disabled.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param skipPayloadMessagePartCheck the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder skipPayloadMessagePartCheck(boolean skipPayloadMessagePartCheck) {
            doSetProperty("skipPayloadMessagePartCheck", skipPayloadMessagePartCheck);
            return this;
        }
        /**
         * Sets whether SOAP message validation should be disabled.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param skipPayloadMessagePartCheck the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointProducerBuilder skipPayloadMessagePartCheck(String skipPayloadMessagePartCheck) {
            doSetProperty("skipPayloadMessagePartCheck", skipPayloadMessagePartCheck);
            return this;
        }
    }

    /**
     * Builder for endpoint for the CXF component.
     */
    public interface CxfEndpointBuilder
            extends
                CxfEndpointConsumerBuilder,
                CxfEndpointProducerBuilder {
        default AdvancedCxfEndpointBuilder advanced() {
            return (AdvancedCxfEndpointBuilder) this;
        }

        /**
         * The data type messages supported by the CXF endpoint.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.common.DataFormat</code> type.
         * 
         * Default: POJO
         * Group: common
         * 
         * @param dataFormat the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder dataFormat(org.apache.camel.component.cxf.common.DataFormat dataFormat) {
            doSetProperty("dataFormat", dataFormat);
            return this;
        }
        /**
         * The data type messages supported by the CXF endpoint.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.common.DataFormat</code> type.
         * 
         * Default: POJO
         * Group: common
         * 
         * @param dataFormat the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder dataFormat(String dataFormat) {
            doSetProperty("dataFormat", dataFormat);
            return this;
        }
        /**
         * The WSDL style that describes how parameters are represented in the
         * SOAP body. If the value is false, CXF will chose the document-literal
         * unwrapped style, If the value is true, CXF will chose the
         * document-literal wrapped style.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         * 
         * @param wrappedStyle the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder wrappedStyle(Boolean wrappedStyle) {
            doSetProperty("wrappedStyle", wrappedStyle);
            return this;
        }
        /**
         * The WSDL style that describes how parameters are represented in the
         * SOAP body. If the value is false, CXF will chose the document-literal
         * unwrapped style, If the value is true, CXF will chose the
         * document-literal wrapped style.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         * 
         * @param wrappedStyle the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder wrappedStyle(String wrappedStyle) {
            doSetProperty("wrappedStyle", wrappedStyle);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound SOAP messages to log.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param loggingFeatureEnabled the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder loggingFeatureEnabled(boolean loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound SOAP messages to log.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param loggingFeatureEnabled the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder loggingFeatureEnabled(String loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled and -1 for no limit.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 49152
         * Group: logging
         * 
         * @param loggingSizeLimit the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder loggingSizeLimit(int loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled and -1 for no limit.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 49152
         * Group: logging
         * 
         * @param loggingSizeLimit the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder loggingSizeLimit(String loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param skipFaultLogging the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder skipFaultLogging(boolean skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: logging
         * 
         * @param skipFaultLogging the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder skipFaultLogging(String skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option is used to set the basic authentication information of
         * password for the CXF client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * This option is used to set the basic authentication information of
         * username for the CXF client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * The bindingId for the service model to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param bindingId the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder bindingId(String bindingId) {
            doSetProperty("bindingId", bindingId);
            return this;
        }
        /**
         * The endpoint name this service is implementing, it maps to the
         * wsdl:portname. In the format of ns:PORT_NAME where ns is a namespace
         * prefix valid at this scope.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param portName the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder portName(String portName) {
            doSetProperty("portName", portName);
            return this;
        }
        /**
         * This option can override the endpointUrl that published from the WSDL
         * which can be accessed with service address url plus wsd.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param publishedEndpointUrl the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder publishedEndpointUrl(String publishedEndpointUrl) {
            doSetProperty("publishedEndpointUrl", publishedEndpointUrl);
            return this;
        }
        /**
         * The class name of the SEI (Service Endpoint Interface) class which
         * could have JSR181 annotation or not.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: service
         * 
         * @param serviceClass the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder serviceClass(Class<java.lang.Object> serviceClass) {
            doSetProperty("serviceClass", serviceClass);
            return this;
        }
        /**
         * The class name of the SEI (Service Endpoint Interface) class which
         * could have JSR181 annotation or not.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: service
         * 
         * @param serviceClass the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder serviceClass(String serviceClass) {
            doSetProperty("serviceClass", serviceClass);
            return this;
        }
        /**
         * The service name this service is implementing, it maps to the
         * wsdl:servicename.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param serviceName the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder serviceName(String serviceName) {
            doSetProperty("serviceName", serviceName);
            return this;
        }
        /**
         * The location of the WSDL. Can be on the classpath, file system, or be
         * hosted remotely.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: service
         * 
         * @param wsdlURL the value to set
         * @return the dsl builder
         */
        default CxfEndpointBuilder wsdlURL(String wsdlURL) {
            doSetProperty("wsdlURL", wsdlURL);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the CXF component.
     */
    public interface AdvancedCxfEndpointBuilder
            extends
                AdvancedCxfEndpointConsumerBuilder,
                AdvancedCxfEndpointProducerBuilder {
        default CxfEndpointBuilder basic() {
            return (CxfEndpointBuilder) this;
        }

        /**
         * This option controls whether the CXF component, when running in
         * PAYLOAD mode, will DOM parse the incoming messages into DOM Elements
         * or keep the payload as a javax.xml.transform.Source object that would
         * allow streaming in some cases.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         * 
         * @param allowStreaming the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder allowStreaming(Boolean allowStreaming) {
            doSetProperty("allowStreaming", allowStreaming);
            return this;
        }
        /**
         * This option controls whether the CXF component, when running in
         * PAYLOAD mode, will DOM parse the incoming messages into DOM Elements
         * or keep the payload as a javax.xml.transform.Source object that would
         * allow streaming in some cases.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param allowStreaming the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder allowStreaming(String allowStreaming) {
            doSetProperty("allowStreaming", allowStreaming);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option is a: <code>org.apache.cxf.Bus</code> type.
         * 
         * Group: advanced
         * 
         * @param bus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder bus(org.apache.cxf.Bus bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option will be converted to a <code>org.apache.cxf.Bus</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param bus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder bus(String bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param continuationTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder continuationTimeout(long continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param continuationTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder continuationTimeout(String continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.common.CxfBinding</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfBinding the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder cxfBinding(org.apache.camel.component.cxf.common.CxfBinding cxfBinding) {
            doSetProperty("cxfBinding", cxfBinding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.common.CxfBinding</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfBinding the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder cxfBinding(String cxfBinding) {
            doSetProperty("cxfBinding", cxfBinding);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.CxfEndpointConfigurer which supports
         * to configure the CXF endpoint in programmatic way. User can configure
         * the CXF server and client by implementing configure{ServerClient}
         * method of CxfEndpointConfigurer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxws.CxfConfigurer</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfConfigurer the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder cxfConfigurer(org.apache.camel.component.cxf.jaxws.CxfConfigurer cxfConfigurer) {
            doSetProperty("cxfConfigurer", cxfConfigurer);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.CxfEndpointConfigurer which supports
         * to configure the CXF endpoint in programmatic way. User can configure
         * the CXF server and client by implementing configure{ServerClient}
         * method of CxfEndpointConfigurer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxws.CxfConfigurer</code> type.
         * 
         * Group: advanced
         * 
         * @param cxfConfigurer the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder cxfConfigurer(String cxfConfigurer) {
            doSetProperty("cxfConfigurer", cxfConfigurer);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param defaultBus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder defaultBus(boolean defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param defaultBus the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder defaultBus(String defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to merge protocol headers. If enabled then propagating
         * headers between Camel and CXF becomes more consistent and similar.
         * For more details see CAMEL-6393.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mergeProtocolHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder mergeProtocolHeaders(boolean mergeProtocolHeaders) {
            doSetProperty("mergeProtocolHeaders", mergeProtocolHeaders);
            return this;
        }
        /**
         * Whether to merge protocol headers. If enabled then propagating
         * headers between Camel and CXF becomes more consistent and similar.
         * For more details see CAMEL-6393.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mergeProtocolHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder mergeProtocolHeaders(String mergeProtocolHeaders) {
            doSetProperty("mergeProtocolHeaders", mergeProtocolHeaders);
            return this;
        }
        /**
         * To enable MTOM (attachments). This requires to use POJO or PAYLOAD
         * data format mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mtomEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder mtomEnabled(boolean mtomEnabled) {
            doSetProperty("mtomEnabled", mtomEnabled);
            return this;
        }
        /**
         * To enable MTOM (attachments). This requires to use POJO or PAYLOAD
         * data format mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param mtomEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder mtomEnabled(String mtomEnabled) {
            doSetProperty("mtomEnabled", mtomEnabled);
            return this;
        }
        /**
         * To set additional CXF options using the key/value pairs from the Map.
         * For example to turn on stacktraces in SOAP faults,
         * properties.faultStackTraceEnabled=true.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the properties(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder properties(String key, Object value) {
            doSetMultiValueProperty("properties", "properties." + key, value);
            return this;
        }
        /**
         * To set additional CXF options using the key/value pairs from the Map.
         * For example to turn on stacktraces in SOAP faults,
         * properties.faultStackTraceEnabled=true.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the properties(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder properties(Map values) {
            doSetMultiValueProperties("properties", "properties.", values);
            return this;
        }
        /**
         * Enable schema validation for request and response. Disabled by
         * default for performance reason.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param schemaValidationEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder schemaValidationEnabled(Boolean schemaValidationEnabled) {
            doSetProperty("schemaValidationEnabled", schemaValidationEnabled);
            return this;
        }
        /**
         * Enable schema validation for request and response. Disabled by
         * default for performance reason.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param schemaValidationEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder schemaValidationEnabled(String schemaValidationEnabled) {
            doSetProperty("schemaValidationEnabled", schemaValidationEnabled);
            return this;
        }
        /**
         * Sets whether SOAP message validation should be disabled.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param skipPayloadMessagePartCheck the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder skipPayloadMessagePartCheck(boolean skipPayloadMessagePartCheck) {
            doSetProperty("skipPayloadMessagePartCheck", skipPayloadMessagePartCheck);
            return this;
        }
        /**
         * Sets whether SOAP message validation should be disabled.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param skipPayloadMessagePartCheck the value to set
         * @return the dsl builder
         */
        default AdvancedCxfEndpointBuilder skipPayloadMessagePartCheck(String skipPayloadMessagePartCheck) {
            doSetProperty("skipPayloadMessagePartCheck", skipPayloadMessagePartCheck);
            return this;
        }
    }

    public interface CxfBuilders {
        /**
         * CXF (camel-cxf-soap)
         * Expose SOAP WebServices using Apache CXF or connect to external
         * WebServices using CXF WS client.
         * 
         * Category: http,webservice
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-cxf-soap
         * 
         * @return the dsl builder for the headers' name.
         */
        default CxfHeaderNameBuilder cxf() {
            return CxfHeaderNameBuilder.INSTANCE;
        }
        /**
         * CXF (camel-cxf-soap)
         * Expose SOAP WebServices using Apache CXF or connect to external
         * WebServices using CXF WS client.
         * 
         * Category: http,webservice
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-cxf-soap
         * 
         * Syntax: <code>cxf:beanId:address</code>
         * 
         * Path parameter: beanId
         * To lookup an existing configured CxfEndpoint. Must used bean: as
         * prefix.
         * 
         * Path parameter: address
         * The service publish address.
         * 
         * @param path beanId:address
         * @return the dsl builder
         */
        default CxfEndpointBuilder cxf(String path) {
            return CxfEndpointBuilderFactory.endpointBuilder("cxf", path);
        }
        /**
         * CXF (camel-cxf-soap)
         * Expose SOAP WebServices using Apache CXF or connect to external
         * WebServices using CXF WS client.
         * 
         * Category: http,webservice
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-cxf-soap
         * 
         * Syntax: <code>cxf:beanId:address</code>
         * 
         * Path parameter: beanId
         * To lookup an existing configured CxfEndpoint. Must used bean: as
         * prefix.
         * 
         * Path parameter: address
         * The service publish address.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path beanId:address
         * @return the dsl builder
         */
        default CxfEndpointBuilder cxf(String componentName, String path) {
            return CxfEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the CXF component.
     */
    public static class CxfHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final CxfHeaderNameBuilder INSTANCE = new CxfHeaderNameBuilder();

        /**
         * The name of the operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code operationName}.
         */
        public String operationName() {
            return "operationName";
        }
        /**
         * The operation namespace.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code operationNamespace}.
         */
        public String operationNamespace() {
            return "operationNamespace";
        }
        /**
         * The destination override url.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DestinationOverrideUrl}.
         */
        public String destinationOverrideUrl() {
            return "CamelDestinationOverrideUrl";
        }
        /**
         * The response context.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code ResponseContext}.
         */
        public String responseContext() {
            return "ResponseContext";
        }
        /**
         * The authentication.
         * 
         * The option is a: {@code javax.security.auth.Subject} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Authentication}.
         */
        public String authentication() {
            return "CamelAuthentication";
        }
        /**
         * The request context.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RequestContext}.
         */
        public String requestContext() {
            return "RequestContext";
        }
    }
    static CxfEndpointBuilder endpointBuilder(String componentName, String path) {
        class CxfEndpointBuilderImpl extends AbstractEndpointBuilder implements CxfEndpointBuilder, AdvancedCxfEndpointBuilder {
            public CxfEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new CxfEndpointBuilderImpl(path);
    }
}