/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectIndexedContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectArrayList<KType>
extends AbstractObjectCollection<KType>
implements ObjectIndexedContainer<KType>,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    private static final Object EMPTY = new Object[0];
    public KType[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public ObjectArrayList() {
        this(5);
    }

    public ObjectArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public ObjectArrayList(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(KType e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(KType e1, KType e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(KType[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    @Override
    public void add(KType ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(ObjectContainer<? extends KType> container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ObjectCursor<KType> objectCursor : container) {
            this.add((KType)objectCursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.add((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, KType e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public KType get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public KType set(int index, KType e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        KType v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public KType remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        KType v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = null;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, null);
    }

    @Override
    public int removeFirstOccurrence(KType e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLastOccurrence(KType e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAllOccurrences(KType e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == null ? this.buffer[from] == null : e1.equals(this.buffer[from])) {
                this.buffer[from] = null;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = null;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(KType e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(KType e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (!(e1 == null ? this.buffer[i] == null : e1.equals(this.buffer[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(KType e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (!(e1 == null ? this.buffer[i] == null : e1.equals(this.buffer[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount >= bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            Object[] newBuffer = (Object[])Internals.newArray(newSize);
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            }
            this.buffer = newBuffer;
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, null);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, null);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, null);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = (Object[])EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public ObjectArrayList<KType> clone() {
        try {
            ObjectArrayList cloned = (ObjectArrayList)super.clone();
            cloned.buffer = (Object[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof ObjectArrayList) {
                ObjectArrayList other = (ObjectArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof ObjectIndexedContainer) {
                ObjectIndexedContainer other = (ObjectIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(Object[] b1, Object[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] != null ? b1[i].equals(b2[i]) : b2[i] == null) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(ObjectIndexedContainer<KType> b1, ObjectIndexedContainer<KType> b2, int length) {
        for (int i = 0; i < length; ++i) {
            KType o1 = b1.get(i);
            KType o2 = b2.get(i);
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator<KType>(this.buffer, this.size());
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        KType[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = null;
                    continue;
                }
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = null;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = null;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        KType[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static <KType> ObjectArrayList<KType> newInstance() {
        return new ObjectArrayList<KType>();
    }

    public static <KType> ObjectArrayList<KType> newInstanceWithCapacity(int initialCapacity) {
        return new ObjectArrayList<KType>(initialCapacity);
    }

    public static <KType> ObjectArrayList<KType> from(KType ... elements) {
        ObjectArrayList<KType> list = new ObjectArrayList<KType>(elements.length);
        list.add(elements);
        return list;
    }

    public static <KType> ObjectArrayList<KType> from(ObjectContainer<KType> container) {
        return new ObjectArrayList<KType>(container);
    }

    static final class ValueIterator<KType>
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private final KType[] buffer;
        private final int size;

        public ValueIterator(KType[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (ObjectCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

