/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Set;
import org.apache.cassandra.io.compress.BufferType;

public interface ICompressor {
    public int initialCompressedBufferLength(int var1);

    public int uncompress(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IOException;

    public void compress(ByteBuffer var1, ByteBuffer var2) throws IOException;

    public void uncompress(ByteBuffer var1, ByteBuffer var2) throws IOException;

    public BufferType preferredBufferType();

    public boolean supports(BufferType var1);

    public Set<String> supportedOptions();

    default public Set<Uses> recommendedUses() {
        return ImmutableSet.copyOf(EnumSet.allOf(Uses.class));
    }

    public static enum Uses {
        GENERAL,
        FAST_COMPRESSION;

    }
}

