/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.streaming.async.NettyStreamingChannel;
import org.apache.cassandra.streaming.async.NettyStreamingConnectionFactory;

public class BulkLoadConnectionFactory
extends NettyStreamingConnectionFactory {
    private final int storagePort;
    private final EncryptionOptions.ServerEncryptionOptions encryptionOptions;

    public BulkLoadConnectionFactory(EncryptionOptions.ServerEncryptionOptions encryptionOptions, int storagePort) {
        this.storagePort = storagePort;
        this.encryptionOptions = encryptionOptions;
    }

    @Override
    public NettyStreamingChannel create(InetSocketAddress to, int messagingVersion, StreamingChannel.Kind kind) throws IOException {
        OutboundConnectionSettings template = new OutboundConnectionSettings(InetAddressAndPort.getByAddress(to));
        return this.create(template, messagingVersion, kind);
    }

    @Override
    public StreamingChannel create(InetSocketAddress to, InetSocketAddress preferred, int messagingVersion, StreamingChannel.Kind kind) throws IOException {
        OutboundConnectionSettings template = new OutboundConnectionSettings(InetAddressAndPort.getByAddress(to), InetAddressAndPort.getByAddress(preferred));
        return this.create(template, messagingVersion, kind);
    }

    private NettyStreamingChannel create(OutboundConnectionSettings template, int messagingVersion, StreamingChannel.Kind kind) throws IOException {
        template = template.withConnectTo(template.to.withPort(this.storagePort));
        if (this.encryptionOptions != null && this.encryptionOptions.internode_encryption != EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.none) {
            template = template.withEncryption(this.encryptionOptions);
        }
        return BulkLoadConnectionFactory.connect(template, messagingVersion, kind);
    }

    @Override
    public boolean supportsPreferredIp() {
        return false;
    }
}

