/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.cassandra.utils.Pair;

public final class CIDR {
    private final InetAddress startIpAddress;
    private final InetAddress endIpAddress;
    private final short netMask;

    public CIDR(InetAddress ipAddress, short netMask) {
        if (netMask > CIDR.maxNetMaskAllowed(ipAddress)) {
            throw new IllegalArgumentException("Invalid netmask " + netMask + " for IP " + ipAddress.getHostAddress());
        }
        Pair<InetAddress, InetAddress> ipRange = CIDR.calcIpRangeOfCidr(ipAddress, netMask);
        this.startIpAddress = ipRange.left();
        this.endIpAddress = ipRange.right();
        this.netMask = netMask;
    }

    public static CIDR getInstance(String cidrStr) {
        InetAddress ipAddress;
        if (cidrStr == null || cidrStr.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s is not a valid CIDR String", cidrStr));
        }
        String[] parts = cidrStr.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException(String.format("%s is not a valid CIDR String", cidrStr));
        }
        short netMask = Short.parseShort(parts[1]);
        try {
            ipAddress = InetAddress.getByName(parts[0]);
            if (ipAddress instanceof Inet4Address && parts[0].contains(":") && parts[0].contains(".")) {
                netMask = (short)(netMask - 96);
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("%s is not a valid CIDR String", cidrStr));
        }
        short maxMaskValue = CIDR.maxNetMaskAllowed(ipAddress);
        if (netMask < 0 || netMask > maxMaskValue) {
            throw new IllegalArgumentException(String.format("%s is not a valid CIDR String", cidrStr));
        }
        return new CIDR(ipAddress, netMask);
    }

    private static short maxNetMaskAllowed(InetAddress ipAddress) {
        if (ipAddress instanceof Inet6Address) {
            return 128;
        }
        return 32;
    }

    private static Pair<InetAddress, InetAddress> calcIpRangeOfCidr(InetAddress ipAddress, short netMask) {
        if (netMask > CIDR.maxNetMaskAllowed(ipAddress)) {
            throw new IllegalArgumentException("Invalid netmask " + netMask + " for IP " + ipAddress.getHostAddress());
        }
        if (netMask == CIDR.maxNetMaskAllowed(ipAddress)) {
            return Pair.create(ipAddress, ipAddress);
        }
        byte[] startIpBytes = ipAddress.getAddress();
        byte[] endIpBytes = ipAddress.getAddress();
        int byteOffset = netMask / 8;
        int bitOffset = netMask % 8;
        int unsignedByte = Byte.toUnsignedInt(startIpBytes[byteOffset]);
        startIpBytes[byteOffset] = (byte)(unsignedByte & 255 << 8 - bitOffset);
        endIpBytes[byteOffset] = (byte)(unsignedByte | 255 >>> bitOffset);
        ++byteOffset;
        while (byteOffset < startIpBytes.length) {
            startIpBytes[byteOffset] = 0;
            endIpBytes[byteOffset] = -1;
            ++byteOffset;
        }
        try {
            return Pair.create(InetAddress.getByAddress(startIpBytes), InetAddress.getByAddress(endIpBytes));
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Invalid bytes for constructing IP", e);
        }
    }

    public InetAddress getStartIpAddress() {
        return this.startIpAddress;
    }

    public InetAddress getEndIpAddress() {
        return this.endIpAddress;
    }

    public short getNetMask() {
        return this.netMask;
    }

    public boolean isIPv4() {
        return this.startIpAddress instanceof Inet4Address;
    }

    public boolean isIPv6() {
        return this.startIpAddress instanceof Inet6Address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIDR cidr = (CIDR)o;
        return this.netMask == cidr.netMask && this.startIpAddress.equals(cidr.startIpAddress) && this.endIpAddress.equals(cidr.endIpAddress);
    }

    public int hashCode() {
        return Objects.hash(this.startIpAddress, this.endIpAddress, this.netMask);
    }

    public String toString() {
        return this.startIpAddress.getHostAddress() + "/" + this.netMask;
    }

    public String asCqlTupleString() {
        return "('" + this.startIpAddress.getHostAddress() + "', " + this.netMask + ")";
    }

    public static int compareIPs(InetAddress l, InetAddress r) {
        byte[] lBytes = l.getAddress();
        byte[] rBytes = r.getAddress();
        for (int i = 0; i < lBytes.length; ++i) {
            int comp = Byte.toUnsignedInt(lBytes[i]) - Byte.toUnsignedInt(rBytes[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public static boolean overlaps(CIDR left, CIDR right) {
        CIDR lower = left;
        CIDR higher = right;
        if (CIDR.compareIPs(left.startIpAddress, right.startIpAddress) > 0) {
            lower = right;
            higher = left;
        }
        return CIDR.compareIPs(lower.endIpAddress, higher.startIpAddress) >= 0;
    }
}

