/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.masking;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionResolver;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.masking.MaskingFunction;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.commons.lang3.StringUtils;

public class ColumnMask {
    public static final String DISABLED_ERROR_MESSAGE = "Cannot mask columns because dynamic data masking is not enabled. You can enable it with the dynamic_data_masking_enabled property on cassandra.yaml";
    public final ScalarFunction function;
    protected final ByteBuffer[] partialArgumentValues;

    public ColumnMask(ScalarFunction function, ByteBuffer ... partialArgumentValues) {
        assert (function.argTypes().size() == partialArgumentValues.length + 1);
        this.function = function;
        this.partialArgumentValues = partialArgumentValues;
    }

    public List<AbstractType<?>> partialArgumentTypes() {
        List<AbstractType<?>> argTypes = this.function.argTypes();
        return argTypes.size() == 1 ? Collections.emptyList() : Collections.unmodifiableList(argTypes.subList(1, argTypes.size()));
    }

    public List<ByteBuffer> partialArgumentValues() {
        return Collections.unmodifiableList(Arrays.asList(this.partialArgumentValues));
    }

    public ColumnMask withReversedType() {
        ReversedType<?> reversed = ReversedType.getInstance(this.function.argTypes().get(0));
        ImmutableList args = ImmutableList.builder().add(reversed).addAll(this.partialArgumentTypes()).build();
        Function newFunction = FunctionResolver.get(this.function.name().keyspace, this.function.name(), (List<? extends AssignmentTestable>)args, null, null, null);
        assert (newFunction != null);
        return new ColumnMask((ScalarFunction)newFunction, this.partialArgumentValues);
    }

    public Masker masker(ProtocolVersion version) {
        return new Masker(version, this.function, this.partialArgumentValues);
    }

    public static void ensureEnabled() {
        if (!DatabaseDescriptor.getDynamicDataMaskingEnabled()) {
            throw new InvalidRequestException(DISABLED_ERROR_MESSAGE);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMask mask = (ColumnMask)o;
        return this.function.name().equals(mask.function.name()) && Arrays.equals(this.partialArgumentValues, mask.partialArgumentValues);
    }

    public int hashCode() {
        return Objects.hash(this.function.name(), Arrays.hashCode(this.partialArgumentValues));
    }

    public String toString() {
        List<AbstractType<?>> types = this.partialArgumentTypes();
        ArrayList<String> arguments = new ArrayList<String>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            CQL3Type type = types.get(i).asCQL3Type();
            ByteBuffer value = this.partialArgumentValues[i];
            arguments.add(type.toCQLLiteral(value));
        }
        return String.format("%s(%s)", this.function.name(), StringUtils.join(arguments, (String)", "));
    }

    public void appendCqlTo(CqlBuilder builder) {
        builder.append(" MASKED WITH ").append(this.toString());
    }

    public static final class Raw {
        public final FunctionName name;
        public final List<Term.Raw> rawPartialArguments;

        public Raw(FunctionName name, List<Term.Raw> rawPartialArguments) {
            this.name = name;
            this.rawPartialArguments = rawPartialArguments;
        }

        public ColumnMask prepare(String keyspace, String table, ColumnIdentifier column, AbstractType<?> type) {
            ScalarFunction function = this.findMaskingFunction(keyspace, table, column, type);
            ByteBuffer[] partialArguments = this.preparePartialArguments(keyspace, function);
            return new ColumnMask(function, partialArguments);
        }

        private ScalarFunction findMaskingFunction(String keyspace, String table, ColumnIdentifier column, AbstractType<?> type) {
            CQL3Type expectedType;
            ArrayList<AssignmentTestable> args = new ArrayList<AssignmentTestable>(this.rawPartialArguments.size() + 1);
            args.add(type);
            args.addAll(this.rawPartialArguments);
            Function function = FunctionResolver.get(keyspace, this.name, args, keyspace, table, type);
            if (function == null) {
                throw RequestValidations.invalidRequest("Unable to find masking function for %s, no declared function matches the signature %s", column, this);
            }
            if (function.isAggregate()) {
                throw RequestValidations.invalidRequest("Aggregate function %s cannot be used for masking table columns", this);
            }
            if (function.isNative() && !(function instanceof MaskingFunction)) {
                throw RequestValidations.invalidRequest("Not-masking function %s cannot be used for masking table columns", this);
            }
            if (!function.isNative() && !function.name().keyspace.equals(keyspace)) {
                throw RequestValidations.invalidRequest("Masking function %s doesn't belong to the same keyspace as the table %s.%s", this, keyspace, table);
            }
            CQL3Type returnType = function.returnType().asCQL3Type();
            if (!returnType.equals(expectedType = type.asCQL3Type())) {
                throw RequestValidations.invalidRequest("Masking function %s return type is %s. This is different to the type of the masked column %s of type %s. Masking functions can only be attached to table columns if they return the same data type as the masked column.", this, returnType, column, expectedType);
            }
            return (ScalarFunction)function;
        }

        private ByteBuffer[] preparePartialArguments(String keyspace, ScalarFunction function) {
            ByteBuffer[] arguments = new ByteBuffer[this.rawPartialArguments.size()];
            for (int i = 0; i < this.rawPartialArguments.size(); ++i) {
                String term = this.rawPartialArguments.get(i).toString();
                AbstractType<?> type = function.argTypes().get(i + 1);
                arguments[i] = Terms.asBytes(keyspace, term, type);
            }
            return arguments;
        }

        public String toString() {
            return String.format("%s(%s)", this.name, StringUtils.join(this.rawPartialArguments, (String)", "));
        }
    }

    public static class Masker {
        private final ScalarFunction function;
        private final Arguments arguments;

        private Masker(ProtocolVersion version, ScalarFunction function, ByteBuffer[] partialArgumentValues) {
            this.function = function;
            this.arguments = function.newArguments(version);
            for (int i = 0; i < partialArgumentValues.length; ++i) {
                this.arguments.set(i + 1, partialArgumentValues[i]);
            }
        }

        public ByteBuffer mask(ByteBuffer value) {
            this.arguments.set(0, value);
            return this.function.execute(this.arguments);
        }
    }
}

