/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

final class TrieIndexEntry
extends AbstractRowIndexEntry {
    final long indexTrieRoot;
    private final int rowIndexBlockCount;
    private final DeletionTime deletionTime;

    TrieIndexEntry(long dataFilePosition, long indexTrieRoot, int rowIndexBlockCount, DeletionTime deletionTime) {
        super(dataFilePosition);
        this.indexTrieRoot = indexTrieRoot;
        this.rowIndexBlockCount = rowIndexBlockCount;
        this.deletionTime = deletionTime;
    }

    public TrieIndexEntry(long position) {
        super(position);
        this.indexTrieRoot = -1L;
        this.rowIndexBlockCount = 0;
        this.deletionTime = null;
    }

    @Override
    public int blockCount() {
        return this.rowIndexBlockCount;
    }

    @Override
    public SSTableFormat<?, ?> getSSTableFormat() {
        throw TrieIndexEntry.noKeyCacheError();
    }

    @Override
    public void serializeForCache(DataOutputPlus out) {
        throw TrieIndexEntry.noKeyCacheError();
    }

    private static AssertionError noKeyCacheError() {
        return new AssertionError((Object)"BTI SSTables should not use key cache");
    }

    @Override
    public DeletionTime deletionTime() {
        return this.deletionTime;
    }

    @Override
    public long unsharedHeapSize() {
        throw new AssertionError((Object)"BTI SSTables index entries should not be persisted in any in-memory structure");
    }

    public void serialize(DataOutputPlus indexFile, long basePosition, Version version) throws IOException {
        assert (this.indexTrieRoot != -1L && this.rowIndexBlockCount > 0 && this.deletionTime != null);
        indexFile.writeUnsignedVInt(this.position);
        indexFile.writeVInt(this.indexTrieRoot - basePosition);
        indexFile.writeUnsignedVInt32(this.rowIndexBlockCount);
        DeletionTime.getSerializer(version).serialize(this.deletionTime, indexFile);
    }

    public static TrieIndexEntry create(long dataStartPosition, long trieRoot, DeletionTime partitionLevelDeletion, int rowIndexBlockCount) {
        return new TrieIndexEntry(dataStartPosition, trieRoot, trieRoot == -1L ? 0 : rowIndexBlockCount, partitionLevelDeletion);
    }

    public static TrieIndexEntry deserialize(DataInputPlus in, long basePosition, Version version) throws IOException {
        long dataFilePosition = in.readUnsignedVInt();
        long indexTrieRoot = in.readVInt() + basePosition;
        int rowIndexBlockCount = in.readUnsignedVInt32();
        DeletionTime deletionTime = DeletionTime.getSerializer(version).deserialize(in);
        return new TrieIndexEntry(dataFilePosition, indexTrieRoot, rowIndexBlockCount, deletionTime);
    }
}

