/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.metrics.TopPartitionTracker;
import org.apache.cassandra.repair.IValidationManager;
import org.apache.cassandra.repair.NoSuchRepairSessionException;
import org.apache.cassandra.repair.PreviewRepairConflictWithIncrementalRepairException;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.repair.ValidationPartitionIterator;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.repair.state.ValidationState;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.apache.cassandra.utils.MerkleTrees;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationManager
implements IValidationManager {
    private static final Logger logger = LoggerFactory.getLogger(ValidationManager.class);
    public static final ValidationManager instance = new ValidationManager();

    private ValidationManager() {
    }

    private static MerkleTrees createMerkleTrees(ValidationPartitionIterator validationIterator, Collection<Range<Token>> ranges, ColumnFamilyStore cfs) {
        MerkleTrees trees = new MerkleTrees(cfs.getPartitioner());
        long allPartitions = validationIterator.estimatedPartitions();
        Map<Range<Token>, Long> rangePartitionCounts = validationIterator.getRangePartitionCounts();
        long availableBytes = DatabaseDescriptor.getRepairSessionSpaceInMiB() * 0x100000 / cfs.keyspace.getReplicationStrategy().getReplicationFactor().allReplicas;
        for (Range<Token> range : ranges) {
            long numPartitions = rangePartitionCounts.get(range);
            double rangeOwningRatio = allPartitions > 0L ? (double)numPartitions / (double)allPartitions : 0.0;
            int rangeAvailableBytes = Math.max(1, (int)(rangeOwningRatio * (double)availableBytes));
            int estimatedMaxDepth = MerkleTree.estimatedMaxDepthForBytes(cfs.getPartitioner(), rangeAvailableBytes, 32);
            int maxDepth = rangeOwningRatio > 0.0 ? Math.min(estimatedMaxDepth, DatabaseDescriptor.getRepairSessionMaxTreeDepth()) : 0;
            int depth = numPartitions > 0L ? (int)Math.min(Math.ceil(Math.log(numPartitions) / Math.log(2.0)), (double)maxDepth) : 0;
            trees.addMerkleTree((int)Math.pow(2.0, depth), range);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created {} merkle trees with merkle trees size {}, {} partitions, {} bytes", new Object[]{trees.ranges().size(), trees.size(), allPartitions, MerkleTrees.serializer.serializedSize(trees, 0)});
        }
        return trees;
    }

    private static ValidationPartitionIterator getValidationIterator(TableRepairManager repairManager, Validator validator, TopPartitionTracker.Collector topPartitionCollector) throws IOException, NoSuchRepairSessionException {
        RepairJobDesc desc = validator.desc;
        return repairManager.getValidationIterator(desc.ranges, desc.parentSessionId, desc.sessionId, validator.isIncremental, validator.nowInSec, topPartitionCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doValidation(ColumnFamilyStore cfs, Validator validator) throws IOException, NoSuchRepairSessionException {
        SharedContext ctx = validator.ctx;
        Clock clock = ctx.clock();
        ValidationState state = validator.state;
        if (!cfs.isValid()) {
            state.phase.skip(String.format("Table %s is not valid", cfs));
            return;
        }
        TopPartitionTracker.Collector topPartitionCollector = null;
        if (cfs.topPartitions != null && DatabaseDescriptor.topPartitionsEnabled() && ValidationManager.isTopPartitionSupported(validator)) {
            topPartitionCollector = new TopPartitionTracker.Collector(validator.desc.ranges);
        }
        long start = clock.nanoTime();
        try (ValidationPartitionIterator vi = ValidationManager.getValidationIterator(ctx.repairManager(cfs), validator, topPartitionCollector);){
            state.phase.start(vi.estimatedPartitions(), vi.getEstimatedBytes());
            MerkleTrees trees = ValidationManager.createMerkleTrees(vi, validator.desc.ranges, cfs);
            validator.prepare(cfs, trees, topPartitionCollector);
            while (vi.hasNext()) {
                UnfilteredRowIterator partition = (UnfilteredRowIterator)vi.next();
                try {
                    validator.add(partition);
                    ++state.partitionsProcessed;
                    state.bytesRead = vi.getBytesRead();
                    if (state.partitionsProcessed % 1024L != 0L) continue;
                    state.updated();
                }
                finally {
                    if (partition == null) continue;
                    partition.close();
                }
            }
            validator.complete();
        }
        finally {
            cfs.metric.bytesValidated.update(state.estimatedTotalBytes);
            cfs.metric.partitionsValidated.update(state.partitionsProcessed);
            if (topPartitionCollector != null) {
                cfs.topPartitions.merge(topPartitionCollector);
            }
        }
        if (logger.isDebugEnabled()) {
            long duration = TimeUnit.NANOSECONDS.toMillis(clock.nanoTime() - start);
            logger.debug("Validation of {} partitions (~{}) finished in {} msec, for {}", new Object[]{state.partitionsProcessed, FBUtilities.prettyPrintMemory(state.estimatedTotalBytes), duration, validator.desc});
        }
    }

    private static boolean isTopPartitionSupported(Validator validator) {
        switch (validator.getPreviewKind()) {
            case NONE: {
                return !validator.isIncremental;
            }
            case ALL: 
            case REPAIRED: {
                return true;
            }
            case UNREPAIRED: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unknown preview kind: " + validator.getPreviewKind()));
    }

    @Override
    public Future<?> submitValidation(final ColumnFamilyStore cfs, final Validator validator) {
        Callable<Object> validation = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                try (TableMetrics.TableTimer.Context c = cfs.metric.validationTime.time();){
                    ValidationManager.doValidation(cfs, validator);
                }
                catch (CompactionInterruptedException | NoSuchRepairSessionException | PreviewRepairConflictWithIncrementalRepairException e) {
                    validator.fail(e);
                    logger.warn(e.getMessage());
                }
                catch (Throwable e) {
                    validator.fail(e);
                    logger.error("Validation failed.", e);
                    throw e;
                }
                return this;
            }
        };
        return cfs.getRepairManager().submitValidation(validation);
    }
}

