/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import org.apache.cassandra.sidecar.client.StreamBuffer;
import org.apache.cassandra.sidecar.client.StreamConsumer;
import org.apache.cassandra.sidecar.client.VertxStreamBuffer;

public class StreamConsumerWriteStream
implements WriteStream<Buffer> {
    private final StreamConsumer streamConsumer;

    public StreamConsumerWriteStream(StreamConsumer streamConsumer) {
        this.streamConsumer = streamConsumer;
    }

    public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    public Future<Void> write(Buffer data) {
        this.streamConsumer.onRead((StreamBuffer)new VertxStreamBuffer(data));
        return Future.succeededFuture();
    }

    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.streamConsumer.onRead((StreamBuffer)new VertxStreamBuffer(data));
        if (handler != null) {
            handler.handle((Object)Future.succeededFuture());
        }
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.streamConsumer.onComplete();
        if (handler != null) {
            handler.handle((Object)Future.succeededFuture());
        }
    }

    public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    public boolean writeQueueFull() {
        return false;
    }

    public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
        return this;
    }
}

