/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base;

import com.google.common.net.HostAndPort;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.adapters.base.NodeInfo;
import org.apache.cassandra.sidecar.adapters.base.RingProvider;
import org.apache.cassandra.sidecar.adapters.base.jmx.ClusterMembershipJmxOperations;
import org.apache.cassandra.sidecar.adapters.base.jmx.EndpointSnitchJmxOperations;
import org.apache.cassandra.sidecar.adapters.base.jmx.GossipDependentStorageJmxOperations;
import org.apache.cassandra.sidecar.adapters.base.jmx.StorageJmxOperations;
import org.apache.cassandra.sidecar.common.response.GossipInfoResponse;
import org.apache.cassandra.sidecar.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioner;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Token;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRangeReplicas;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.utils.GossipInfoParser;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRangeReplicaProvider {
    protected final JmxClient jmxClient;
    private final DnsResolver dnsResolver;
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenRangeReplicaProvider.class);

    public TokenRangeReplicaProvider(JmxClient jmxClient, DnsResolver dnsResolver) {
        this.jmxClient = jmxClient;
        this.dnsResolver = dnsResolver;
    }

    public TokenRangeReplicasResponse tokenRangeReplicas(Name keyspace, Partitioner partitioner) {
        Objects.requireNonNull(keyspace, "keyspace must be non-null");
        StorageJmxOperations storage = this.initializeStorageOps();
        List<TokenRangeReplicas> naturalTokenRangeReplicas = this.getTokenRangeReplicas("Natural", keyspace.name(), partitioner, storage::getRangeToEndpointWithPortMap);
        List<TokenRangeReplicas> pendingTokenRangeReplicas = this.getTokenRangeReplicas("Pending", keyspace.name(), partitioner, storage::getPendingRangeToEndpointWithPortMap);
        ArrayList<TokenRangeReplicas> allTokenRangeReplicas = new ArrayList<TokenRangeReplicas>(naturalTokenRangeReplicas);
        allTokenRangeReplicas.addAll(pendingTokenRangeReplicas);
        Map<String, String> hostToDatacenter = this.buildHostToDatacenterMapping(allTokenRangeReplicas);
        List<TokenRangeReplicasResponse.ReplicaInfo> writeReplicas = this.writeReplicasFromPendingRanges(allTokenRangeReplicas, hostToDatacenter);
        List<TokenRangeReplicasResponse.ReplicaInfo> readReplicas = this.readReplicasFromReplicaMapping(naturalTokenRangeReplicas, hostToDatacenter);
        Map<String, TokenRangeReplicasResponse.ReplicaMetadata> replicaMetadata = this.replicaMetadata(allTokenRangeReplicas, storage, hostToDatacenter);
        return new TokenRangeReplicasResponse(writeReplicas, readReplicas, replicaMetadata);
    }

    private List<TokenRangeReplicas> getTokenRangeReplicas(String rangeType, String keyspace, Partitioner partitioner, KeyspaceToRangeMappingFunc rangeMappingSupplier) {
        Map rangeMappings = (Map)rangeMappingSupplier.apply(keyspace);
        LOGGER.debug("{} token range mappings for keyspace={}, rangeMappings={}", new Object[]{rangeType, keyspace, rangeMappings});
        return this.transformRangeMappings(rangeMappings, partitioner);
    }

    private List<TokenRangeReplicas> transformRangeMappings(Map<List<String>, List<String>> replicaMappings, Partitioner partitioner) {
        return replicaMappings.entrySet().stream().map(entry -> TokenRangeReplicas.generateTokenRangeReplicas((Token)Token.from((String)((String)((List)entry.getKey()).get(0))), (Token)Token.from((String)((String)((List)entry.getKey()).get(1))), (Partitioner)partitioner, new HashSet((Collection)entry.getValue()))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Map<String, TokenRangeReplicasResponse.ReplicaMetadata> replicaMetadata(List<TokenRangeReplicas> replicaSet, StorageJmxOperations storage, Map<String, String> hostToDatacenter) {
        List<String> joiningNodes = storage.getJoiningNodesWithPort();
        List<String> leavingNodes = storage.getLeavingNodesWithPort();
        List<String> movingNodes = storage.getMovingNodesWithPort();
        List<String> liveNodes = storage.getLiveNodesWithPort();
        List<String> deadNodes = storage.getUnreachableNodesWithPort();
        String rawGossipInfo = this.getRawGossipInfo();
        GossipInfoResponse gossipInfo = GossipInfoParser.parse((String)rawGossipInfo);
        StateWithReplacement state = new StateWithReplacement(joiningNodes, leavingNodes, movingNodes, gossipInfo);
        RingProvider.Status status = new RingProvider.Status(liveNodes, deadNodes);
        return replicaSet.stream().map(TokenRangeReplicas::replicaSet).flatMap(Collection::stream).distinct().map(replica -> {
            try {
                HostAndPort hap = HostAndPort.fromString((String)replica);
                String fqdn = this.dnsResolver.reverseResolve(hap.getHost());
                String datacenter = (String)hostToDatacenter.get(replica);
                return new AbstractMap.SimpleEntry<String, TokenRangeReplicasResponse.ReplicaMetadata>((String)replica, new TokenRangeReplicasResponse.ReplicaMetadata(state.of((String)replica), status.of((String)replica), fqdn, hap.getHost(), hap.getPort(), datacenter));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(String.format("Failed to resolve fqdn for replica %s ", replica), e);
            }
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    protected EndpointSnitchJmxOperations initializeEndpointProxy() {
        return (EndpointSnitchJmxOperations)this.jmxClient.proxy(EndpointSnitchJmxOperations.class, "org.apache.cassandra.db:type=EndpointSnitchInfo");
    }

    protected StorageJmxOperations initializeStorageOps() {
        return new GossipDependentStorageJmxOperations((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService"));
    }

    protected String getRawGossipInfo() {
        return ((ClusterMembershipJmxOperations)this.jmxClient.proxy(ClusterMembershipJmxOperations.class, "org.apache.cassandra.net:type=FailureDetector")).getAllEndpointStatesWithPort();
    }

    private List<TokenRangeReplicasResponse.ReplicaInfo> writeReplicasFromPendingRanges(List<TokenRangeReplicas> tokenRangeReplicaSet, Map<String, String> hostToDatacenter) {
        return TokenRangeReplicas.normalize(tokenRangeReplicaSet).stream().map(range -> TokenRangeReplicaProvider.buildReplicaInfo(hostToDatacenter, range)).collect(Collectors.toList());
    }

    private List<TokenRangeReplicasResponse.ReplicaInfo> readReplicasFromReplicaMapping(List<TokenRangeReplicas> naturalTokenRangeReplicas, Map<String, String> hostToDatacenter) {
        return naturalTokenRangeReplicas.stream().sorted().map(rep -> TokenRangeReplicaProvider.buildReplicaInfo(hostToDatacenter, rep)).collect(Collectors.toList());
    }

    @NotNull
    private static TokenRangeReplicasResponse.ReplicaInfo buildReplicaInfo(Map<String, String> hostToDatacenter, TokenRangeReplicas rep) {
        Map<String, List<String>> replicasByDc = TokenRangeReplicaProvider.replicasByDataCenter(hostToDatacenter, rep.replicaSet());
        return new TokenRangeReplicasResponse.ReplicaInfo(rep.start().toBigInteger().toString(), rep.end().toBigInteger().toString(), replicasByDc);
    }

    private Map<String, String> buildHostToDatacenterMapping(List<TokenRangeReplicas> replicaSet) {
        EndpointSnitchJmxOperations endpointSnitchInfo = this.initializeEndpointProxy();
        return replicaSet.stream().map(TokenRangeReplicas::replicaSet).flatMap(Collection::stream).distinct().collect(Collectors.toMap(Function.identity(), host -> this.getDatacenter(endpointSnitchInfo, (String)host)));
    }

    private String getDatacenter(EndpointSnitchJmxOperations endpointSnitchInfo, String host) {
        try {
            return endpointSnitchInfo.getDatacenter(host);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static Map<String, List<String>> replicasByDataCenter(Map<String, String> hostToDatacenter, Collection<String> replicas) {
        HashMap<String, List<String>> dcReplicaMapping = new HashMap<String, List<String>>();
        replicas.stream().filter(hostToDatacenter::containsKey).forEach(item -> dcReplicaMapping.computeIfAbsent((String)hostToDatacenter.get(item), v -> new ArrayList()).add(item));
        return dcReplicaMapping;
    }

    static class StateWithReplacement
    extends RingProvider.State {
        private final GossipInfoResponse gossipInfo;

        StateWithReplacement(List<String> joiningNodes, List<String> leavingNodes, List<String> movingNodes, GossipInfoResponse gossipInfo) {
            super(joiningNodes, leavingNodes, movingNodes);
            this.gossipInfo = gossipInfo;
        }

        @Override
        String of(String endpoint) {
            GossipInfoResponse.GossipInfo gossipInfoEntry;
            if (this.joiningNodes.contains(endpoint) && (gossipInfoEntry = this.gossipInfo.get((Object)endpoint)) != null) {
                LOGGER.debug("Found gossipInfoEntry={}", (Object)gossipInfoEntry);
                String hostStatus = gossipInfoEntry.status();
                String hostStatusWithPort = gossipInfoEntry.statusWithPort();
                if (hostStatus != null && hostStatus.startsWith("BOOT_REPLACE,") || hostStatusWithPort != null && hostStatusWithPort.startsWith("BOOT_REPLACE,")) {
                    return NodeInfo.NodeState.REPLACING.displayName();
                }
            }
            return super.of(endpoint);
        }
    }

    private static interface KeyspaceToRangeMappingFunc
    extends Function<String, Map<List<String>, List<String>>> {
    }
}

