/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractConverter;

public class ArrayConverter<C>
extends AbstractConverter<C> {
    private final Class<C> defaultType;
    private final Converter elementConverter;
    private int defaultSize;
    private char delimiter = (char)44;
    private char[] allowedChars = new char[]{'.', '-'};
    private boolean onlyFirstToString = true;

    public ArrayConverter(Class<C> defaultType, Converter elementConverter) {
        Objects.requireNonNull(defaultType, "defaultType");
        if (!defaultType.isArray()) {
            throw new IllegalArgumentException("Default type must be an array.");
        }
        this.elementConverter = Objects.requireNonNull(elementConverter, "elementConverter");
        this.defaultType = defaultType;
    }

    public ArrayConverter(Class<C> defaultType, Converter elementConverter, int defaultSize) {
        this(defaultType, elementConverter);
        this.defaultSize = defaultSize;
        Object defaultValue = null;
        if (defaultSize >= 0) {
            defaultValue = Array.newInstance(defaultType.getComponentType(), defaultSize);
        }
        this.setDefaultValue(defaultValue);
    }

    @Override
    protected Object convertArray(Object value) {
        return value;
    }

    protected Collection<?> convertToCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Date) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(value);
            return list;
        }
        return this.parseElements(value.toString());
    }

    @Override
    protected String convertToString(Object value) {
        int size = 0;
        Iterator<?> iterator = null;
        Class<?> type = value.getClass();
        if (type.isArray()) {
            size = Array.getLength(value);
        } else {
            Collection<?> collection = this.convertToCollection(value);
            size = collection.size();
            iterator = collection.iterator();
        }
        if (size == 0) {
            return (String)this.getDefault(String.class);
        }
        if (this.onlyFirstToString) {
            size = 1;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buffer.append(this.delimiter);
            }
            Object element = iterator == null ? Array.get(value, i) : iterator.next();
            if ((element = this.elementConverter.convert(String.class, element)) == null) continue;
            buffer.append(element);
        }
        return buffer.toString();
    }

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (!type.isArray()) {
            throw ConversionException.format("%s cannot handle conversion to '%s' (not an array).", this.toString(this.getClass()), this.toString(type));
        }
        int size = 0;
        Iterator<?> iterator = null;
        if (value.getClass().isArray()) {
            size = Array.getLength(value);
        } else {
            Collection<?> collection = this.convertToCollection(value);
            size = collection.size();
            iterator = collection.iterator();
        }
        Class<?> componentType = type.getComponentType();
        Object newArray = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Object element = iterator == null ? Array.get(value, i) : iterator.next();
            element = this.elementConverter.convert(componentType, element);
            Array.set(newArray, i, element);
        }
        return (T)newArray;
    }

    @Override
    protected Object getDefault(Class<?> type) {
        if (type.equals(String.class)) {
            return null;
        }
        Object defaultValue = super.getDefault(type);
        if (defaultValue == null) {
            return null;
        }
        if (defaultValue.getClass().equals(type)) {
            return defaultValue;
        }
        return Array.newInstance(type.getComponentType(), this.defaultSize);
    }

    @Override
    protected Class<C> getDefaultType() {
        return this.defaultType;
    }

    private List<String> parseElements(String value) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Parsing elements, delimiter=[" + this.delimiter + "], value=[" + value + "]"));
        }
        if ((value = ArrayConverter.toTrim(value)).startsWith("{") && value.endsWith("}")) {
            value = value.substring(1, value.length() - 1);
        }
        String typeName = this.toString(String.class);
        try {
            int ttype;
            StreamTokenizer st = new StreamTokenizer(new StringReader(value));
            st.whitespaceChars(this.delimiter, this.delimiter);
            st.ordinaryChars(48, 57);
            st.wordChars(48, 57);
            for (char allowedChar : this.allowedChars) {
                st.ordinaryChars(allowedChar, allowedChar);
                st.wordChars(allowedChar, allowedChar);
            }
            ArrayList<String> list = null;
            while ((ttype = st.nextToken()) == -3 || ttype > 0) {
                if (st.sval == null) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(st.sval);
            }
            if (ttype != -1) {
                throw ConversionException.format("Encountered token of type %s parsing elements to '%s'.", ttype, typeName);
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)(list.size() + " elements parsed"));
            }
            return list;
        }
        catch (IOException e) {
            throw new ConversionException("Error converting from String to '" + typeName + "': " + e.getMessage(), e);
        }
    }

    public void setAllowedChars(char[] allowedChars) {
        this.allowedChars = (char[])Objects.requireNonNull(allowedChars, "allowedChars").clone();
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setOnlyFirstToString(boolean onlyFirstToString) {
        this.onlyFirstToString = onlyFirstToString;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.toString(this.getClass()));
        buffer.append("[UseDefault=");
        buffer.append(this.isUseDefault());
        buffer.append(", ");
        buffer.append(this.elementConverter.toString());
        buffer.append(']');
        return buffer.toString();
    }
}

