/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Formattable;
import java.util.Formatter;
import org.apache.commons.text.FormattableUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormattableUtilsTest {
    @Test
    public void testPublicConstructorExists() {
        new FormattableUtils();
    }

    @Test
    public void testSimplestFormat() {
        SimplestFormattable formattable = new SimplestFormattable("foo");
        Assertions.assertThat((String)FormattableUtils.toString((Formattable)formattable)).isEqualTo((Object)"foo");
    }

    @Test
    public void testDefaultAppend() {
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)-1).toString()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)2).toString()).isEqualTo((Object)"fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)4, (int)-1).toString()).isEqualTo((Object)" foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)6, (int)-1).toString()).isEqualTo((Object)"   foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)3, (int)2).toString()).isEqualTo((Object)" fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)5, (int)2).toString()).isEqualTo((Object)"   fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)4, (int)-1).toString()).isEqualTo((Object)"foo ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)6, (int)-1).toString()).isEqualTo((Object)"foo   ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)3, (int)2).toString()).isEqualTo((Object)"fo ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)5, (int)2).toString()).isEqualTo((Object)"fo   ");
    }

    @Test
    public void testAlternatePadCharacter() {
        int pad = 95;
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)-1, (char)'_').toString()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)2, (char)'_').toString()).isEqualTo((Object)"fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)4, (int)-1, (char)'_').toString()).isEqualTo((Object)"_foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)6, (int)-1, (char)'_').toString()).isEqualTo((Object)"___foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)3, (int)2, (char)'_').toString()).isEqualTo((Object)"_fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)5, (int)2, (char)'_').toString()).isEqualTo((Object)"___fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)4, (int)-1, (char)'_').toString()).isEqualTo((Object)"foo_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)6, (int)-1, (char)'_').toString()).isEqualTo((Object)"foo___");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)3, (int)2, (char)'_').toString()).isEqualTo((Object)"fo_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)5, (int)2, (char)'_').toString()).isEqualTo((Object)"fo___");
    }

    @Test
    public void testEllipsis() {
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)-1, (CharSequence)"*").toString()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)2, (CharSequence)"*").toString()).isEqualTo((Object)"f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)4, (int)-1, (CharSequence)"*").toString()).isEqualTo((Object)" foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)6, (int)-1, (CharSequence)"*").toString()).isEqualTo((Object)"   foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)3, (int)2, (CharSequence)"*").toString()).isEqualTo((Object)" f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)5, (int)2, (CharSequence)"*").toString()).isEqualTo((Object)"   f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)4, (int)-1, (CharSequence)"*").toString()).isEqualTo((Object)"foo ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)6, (int)-1, (CharSequence)"*").toString()).isEqualTo((Object)"foo   ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)3, (int)2, (CharSequence)"*").toString()).isEqualTo((Object)"f* ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)5, (int)2, (CharSequence)"*").toString()).isEqualTo((Object)"f*   ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)-1, (CharSequence)"+*").toString()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)2, (CharSequence)"+*").toString()).isEqualTo((Object)"+*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)4, (int)-1, (CharSequence)"+*").toString()).isEqualTo((Object)" foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)6, (int)-1, (CharSequence)"+*").toString()).isEqualTo((Object)"   foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)3, (int)2, (CharSequence)"+*").toString()).isEqualTo((Object)" +*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)5, (int)2, (CharSequence)"+*").toString()).isEqualTo((Object)"   +*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)4, (int)-1, (CharSequence)"+*").toString()).isEqualTo((Object)"foo ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)6, (int)-1, (CharSequence)"+*").toString()).isEqualTo((Object)"foo   ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)3, (int)2, (CharSequence)"+*").toString()).isEqualTo((Object)"+* ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)5, (int)2, (CharSequence)"+*").toString()).isEqualTo((Object)"+*   ");
    }

    @Test
    public void testIllegalEllipsis() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)1, (CharSequence)"xx"));
    }

    @Test
    public void testAlternatePadCharAndEllipsis() {
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)4, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"_foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)6, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"___foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)3, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"_f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)5, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"___f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)4, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"foo_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)6, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"foo___");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)3, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"f*_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)5, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo((Object)"f*___");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)-1, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"+*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)4, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"_foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)6, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"___foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)3, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"_+*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)0, (int)5, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"___+*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)4, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"foo_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)6, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"foo___");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)3, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"+*_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)new Formatter(), (int)1, (int)5, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo((Object)"+*___");
    }

    @Test
    public void testAppendWithNullFormatterAndIntsThrowsNullPointerException() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> FormattableUtils.append((CharSequence)"", null, (int)0, (int)0, (int)0, (char)'}'));
    }

    static class SimplestFormattable
    implements Formattable {
        private final String text;

        SimplestFormattable(String text) {
            this.text = text;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            formatter.format(this.text, new Object[0]);
        }
    }
}

