/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation.options;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.commandline.Arg;
import org.apache.rat.documentation.options.AbstractOption;
import org.apache.rat.utils.CasedString;

public class MavenOption
extends AbstractOption {
    private static final Map<Arg, String> DEFAULT_VALUES = new HashMap<Arg, String>();
    private static final Set<Option> UNSUPPORTED_LIST = new HashSet<Option>();
    private static final Map<String, String> RENAME_MAP = new HashMap<String, String>();
    private static final Predicate<Option> MAVEN_FILTER;

    public static List<MavenOption> getMavenOptions() {
        return OptionCollection.buildOptions().getOptions().stream().filter(MAVEN_FILTER).map(MavenOption::new).collect(Collectors.toList());
    }

    public MavenOption(Option option) {
        super(option, MavenOption.createName(option));
    }

    public static Map<String, String> getRenameMap() {
        return Collections.unmodifiableMap(RENAME_MAP);
    }

    public static Set<Option> getFilteredOptions() {
        return Collections.unmodifiableSet(UNSUPPORTED_LIST);
    }

    static String createName(Option option) {
        String name = StringUtils.defaultIfEmpty(option.getLongOpt(), option.getOpt());
        name = StringUtils.defaultIfEmpty(RENAME_MAP.get(name), name).toLowerCase(Locale.ROOT);
        return new CasedString(CasedString.StringCase.KEBAB, name).toCase(CasedString.StringCase.CAMEL);
    }

    @Override
    protected String cleanupName(Option option) {
        return String.format("<%s>", MavenOption.createName(option));
    }

    @Override
    public String getText() {
        return this.cleanupName(this.option);
    }

    @Override
    public String getDefaultValue() {
        Arg arg = Arg.findArg(this.option);
        String result = DEFAULT_VALUES.get((Object)arg);
        if (result == null) {
            result = arg.defaultValue();
        }
        return result;
    }

    public String getPropertyAnnotation(String fname) {
        String defaultValue;
        StringBuilder sb = new StringBuilder("@Parameter");
        String property = this.option.hasArgs() ? null : String.format("property = \"rat.%s\"", fname);
        String string = defaultValue = this.option.isDeprecated() ? null : this.getDefaultValue();
        if (property != null || defaultValue != null) {
            sb.append("(");
            if (property != null) {
                sb.append(property).append(defaultValue != null ? ", " : "");
            }
            if (defaultValue != null) {
                sb.append(String.format("defaultValue = \"%s\"", defaultValue));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getMethodSignature(String indent, boolean multiple) {
        String args;
        StringBuilder sb = new StringBuilder();
        if (this.isDeprecated()) {
            sb.append(String.format("%s@Deprecated%n", indent));
        }
        String fname = WordUtils.capitalize(this.name);
        String string = args = this.option.hasArg() ? "String" : "boolean";
        if (multiple) {
            if (!(fname.endsWith("s") || fname.endsWith("Approved") || fname.endsWith("Denied"))) {
                fname = fname + "s";
            }
            args = args + "[]";
        }
        return sb.append(String.format("%1$s%5$s%n%1$spublic void set%3$s(%4$s %2$s)", indent, this.name, fname, args, this.getPropertyAnnotation(fname))).toString();
    }

    @Override
    public String getExample() {
        if (UNSUPPORTED_LIST.contains(this.option)) {
            return "-- not supported --";
        }
        if (this.hasArg()) {
            return String.format("<%1$s>%2$s</%1$s>", this.getName(), this.getArgName());
        }
        return String.format("<%s />", this.getName());
    }

    static {
        RENAME_MAP.put("addLicense", "add-license");
        DEFAULT_VALUES.put(Arg.OUTPUT_FILE, "${project.build.directory}/rat.txt");
        UNSUPPORTED_LIST.addAll(Arg.DIR.group().getOptions());
        UNSUPPORTED_LIST.addAll(Arg.LOG_LEVEL.group().getOptions());
        UNSUPPORTED_LIST.add(OptionCollection.HELP);
        Set<Option> filteredOptions = MavenOption.getFilteredOptions();
        MAVEN_FILTER = option -> !filteredOptions.contains(option) && option.getLongOpt() != null;
    }
}

