/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.rat.ConfigurationException;
import org.apache.rat.ImplementationException;
import org.apache.rat.OptionCollection;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.Reporter;
import org.apache.rat.anttasks.BaseAntTask;
import org.apache.rat.anttasks.Family;
import org.apache.rat.anttasks.License;
import org.apache.rat.anttasks.ResourceCollectionContainer;
import org.apache.rat.commandline.Arg;
import org.apache.rat.commandline.StyleSheets;
import org.apache.rat.document.DocumentName;
import org.apache.rat.help.Licenses;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;

public class Report
extends BaseAntTask {
    private final List<License> licenses = new ArrayList<License>();
    private final List<Family> families = new ArrayList<Family>();
    private final DeprecatedConfig deprecatedConfig = new DeprecatedConfig();
    private Union nestedResources;

    public Report() {
        if (DefaultLog.getInstance() instanceof DefaultLog) {
            DefaultLog.setInstance(new Logger());
        }
    }

    public void add(ResourceCollection rc) {
        if (this.nestedResources == null) {
            this.nestedResources = new Union();
        }
        this.nestedResources.add(rc);
    }

    @Deprecated
    public void setInputFileFilter(IOFileFilter inputFileFilter) {
        this.deprecatedConfig.inputFileFilter = inputFileFilter;
    }

    @Deprecated
    public void setReportFile(File reportFile) {
        this.setOut(reportFile.getAbsolutePath());
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    public void addFamily(Family family) {
        this.families.add(family);
    }

    @Deprecated
    public void addStylesheet(Resource styleSheet) {
        this.setStylesheet(styleSheet.getName());
    }

    @Deprecated
    public void addStyleSheet(Resource styleSheet) {
        this.setStylesheet(styleSheet.getName());
    }

    @Deprecated
    public void setStyleReport(boolean styleReport) {
        this.setXml(!styleReport);
    }

    @Deprecated
    public void setFormat(String style) {
        this.setStyleReport("styled".equalsIgnoreCase(style));
    }

    public void setLicenses(File fileName) {
        try {
            this.createLicenses().addText(fileName.getCanonicalPath());
        }
        catch (IOException e) {
            throw new BuildException("Unable to read license file " + fileName, (Throwable)e);
        }
    }

    @Deprecated
    public void setUseDefaultLicenses(boolean useDefaultLicenses) {
        this.setNoDefaultLicenses(!useDefaultLicenses);
    }

    @Deprecated
    public void setAddApprovedLicense(String familyCategory) {
        this.deprecatedConfig.approvedLicenseCategories.add(familyCategory);
    }

    public void addAddApprovedLicense(String familyCategory) {
        this.deprecatedConfig.approvedLicenseCategories.add(familyCategory);
    }

    @Deprecated
    public void setRemoveApprovedLicense(String familyCategory) {
        this.deprecatedConfig.removedLicenseCategories.add(familyCategory);
    }

    public void addRemoveApprovedLicense(String familyCategory) {
        this.deprecatedConfig.removedLicenseCategories.add(familyCategory);
    }

    @Deprecated
    public void setRemoveApprovedLicense(String[] familyCategory) {
        this.deprecatedConfig.removedLicenseCategories.addAll(Arrays.asList(familyCategory));
    }

    public void addRemoveApprovedLicense(String[] familyCategory) {
        this.deprecatedConfig.removedLicenseCategories.addAll(Arrays.asList(familyCategory));
    }

    @Deprecated
    public void setCopyrightMessage(String copyrightMessage) {
        this.setCopyright(copyrightMessage);
    }

    @Deprecated
    public void setAddLicenseHeaders(AddLicenseHeaders setting) {
        switch (setting.getNative()) {
            case TRUE: {
                this.setAddLicense(true);
                break;
            }
            case FALSE: {
                this.setAddLicense(false);
                break;
            }
            case FORCED: {
                this.setAddLicense(true);
                this.setForce(true);
            }
        }
    }

    @Deprecated
    public void setAddDefaultDefinitions(File fileName) {
        try {
            BaseAntTask.Licenses lic = this.createLicenses();
            lic.addText(fileName.getCanonicalPath());
        }
        catch (IOException e) {
            throw new BuildException("Unable to read license file " + fileName, (Throwable)e);
        }
    }

    protected List<String> getValues(Arg arg) {
        ArrayList<String> result = new ArrayList<String>();
        for (Option option : arg.group().getOptions()) {
            List<String> args;
            if (option.getLongOpt() == null || (args = this.getArg(option.getLongOpt())) == null) continue;
            result.addAll(args);
        }
        return result;
    }

    protected void removeKey(Arg arg) {
        for (Option option : arg.group().getOptions()) {
            if (option.getLongOpt() == null) continue;
            this.removeArg(option.getLongOpt());
        }
    }

    public ReportConfiguration getConfiguration() {
        try {
            boolean helpLicenses = !this.getValues(Arg.HELP_LICENSES).isEmpty();
            this.removeKey(Arg.HELP_LICENSES);
            ReportConfiguration configuration = OptionCollection.parseCommands(this.args().toArray(new String[0]), o -> DefaultLog.getInstance().warn("Help option not supported"), true);
            if (this.getValues(Arg.OUTPUT_FILE).isEmpty()) {
                configuration.setOut(() -> new LogOutputStream((Task)this, 2));
            }
            DocumentName name = new DocumentName(this.getProject().getBaseDir());
            configuration.setReportable(new ResourceCollectionContainer(name, configuration, (ResourceCollection)this.nestedResources));
            configuration.addApprovedLicenseCategories(this.deprecatedConfig.approvedLicenseCategories);
            configuration.removeApprovedLicenseCategories(this.deprecatedConfig.removedLicenseCategories);
            if (this.deprecatedConfig.inputFileFilter != null) {
                configuration.addExcludedFilter(this.deprecatedConfig.inputFileFilter);
            }
            this.families.stream().map(Family::build).forEach(configuration::addFamily);
            this.licenses.stream().map(License::asBuilder).forEach(l -> configuration.addApprovedLicenseCategory(configuration.addLicense((ILicense.Builder)l).getLicenseFamily()));
            if (helpLicenses) {
                new Licenses(configuration, new PrintWriter(DefaultLog.getInstance().asWriter())).printHelp();
            }
            return configuration;
        }
        catch (IOException | ImplementationException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void execute() {
        try {
            Reporter r = new Reporter(this.validate(this.getConfiguration()));
            r.output(StyleSheets.PLAIN.getStyleSheet(), () -> new ReportConfiguration.NoCloseOutputStream(System.out));
            r.output();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception ioex) {
            throw new BuildException((Throwable)ioex);
        }
    }

    protected ReportConfiguration validate(ReportConfiguration cfg) {
        try {
            cfg.validate((String s) -> this.log((String)s, 1));
        }
        catch (ConfigurationException e) {
            throw new BuildException(e.getMessage(), e.getCause());
        }
        if (this.nestedResources == null) {
            throw new BuildException("You must specify at least one file to create the report for.");
        }
        return cfg;
    }

    private static class DeprecatedConfig {
        private IOFileFilter inputFileFilter;
        private final Set<String> approvedLicenseCategories = new HashSet<String>();
        private final Set<String> removedLicenseCategories = new HashSet<String>();

        private DeprecatedConfig() {
        }
    }

    private class Logger
    implements Log {
        private final DefaultLogger delegate = new DefaultLogger();

        private Logger() {
        }

        @Override
        public Log.Level getLevel() {
            switch (this.delegate.getMessageOutputLevel()) {
                case 0: {
                    return Log.Level.ERROR;
                }
                case 1: {
                    return Log.Level.WARN;
                }
                case 2: {
                    return Log.Level.INFO;
                }
                case 3: 
                case 4: {
                    return Log.Level.DEBUG;
                }
            }
            return Log.Level.OFF;
        }

        @Override
        public void log(Log.Level level, String msg) {
            this.log(level, msg, null);
        }

        @Override
        public void log(Log.Level level, String message, Throwable throwable) {
            BuildEvent event = new BuildEvent((Task)Report.this);
            switch (level) {
                case DEBUG: {
                    event.setMessage(message, 4);
                    break;
                }
                case INFO: {
                    event.setMessage(message, 2);
                    break;
                }
                case WARN: {
                    event.setMessage(message, 1);
                    break;
                }
                case ERROR: {
                    event.setMessage(message, 0);
                    break;
                }
                default: {
                    return;
                }
            }
            if (throwable != null) {
                event.setException(throwable);
            }
            this.delegate.messageLogged(event);
        }
    }

    @Deprecated
    public static class AddLicenseHeaders
    extends EnumeratedAttribute {
        static final String TRUE = "true";
        static final String FALSE = "false";
        static final String FORCED = "forced";

        public AddLicenseHeaders() {
        }

        public AddLicenseHeaders(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return new String[]{TRUE, FALSE, FORCED};
        }

        public org.apache.rat.config.AddLicenseHeaders getNative() {
            return org.apache.rat.config.AddLicenseHeaders.valueOf(this.getValue().toUpperCase());
        }
    }

    @Deprecated
    public static class ApprovalFilter
    extends EnumeratedAttribute {
        public ApprovalFilter() {
        }

        public ApprovalFilter(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return Arrays.stream(LicenseSetFactory.LicenseFilter.values()).map(Enum::name).collect(Collectors.toList()).toArray(new String[LicenseSetFactory.LicenseFilter.values().length]);
        }

        public LicenseSetFactory.LicenseFilter internalFilter() {
            return LicenseSetFactory.LicenseFilter.valueOf(this.getValue());
        }
    }
}

