/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.xml;

import java.util.ArrayList;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.DefaultAnalyserFactory;
import org.apache.rat.document.DocumentAnalyserMultiplexer;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.policy.DefaultPolicy;
import org.apache.rat.report.ConfigurationReport;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.claim.ClaimAggregator;
import org.apache.rat.report.claim.ClaimReporterMultiplexer;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.report.claim.ClaimValidatorReport;
import org.apache.rat.report.claim.LicenseAddingReport;
import org.apache.rat.report.claim.SimpleXmlClaimReporter;
import org.apache.rat.report.xml.writer.IXmlWriter;

public final class XmlReportFactory {
    private XmlReportFactory() {
    }

    public static RatReport createStandardReport(IXmlWriter writer, ClaimStatistic statistic, ReportConfiguration configuration) {
        ArrayList<RatReport> reporters = new ArrayList<RatReport>();
        if (statistic != null) {
            reporters.add(new ClaimAggregator(statistic));
        }
        if (configuration.isAddingLicenses() && !configuration.isDryRun()) {
            reporters.add(new LicenseAddingReport(configuration.getCopyrightMessage(), configuration.isAddingLicensesForced()));
        }
        if (configuration.listFamilies() != LicenseSetFactory.LicenseFilter.NONE || configuration.listLicenses() != LicenseSetFactory.LicenseFilter.NONE) {
            reporters.add(new ConfigurationReport(writer, configuration));
        }
        reporters.add(new SimpleXmlClaimReporter(writer));
        reporters.add(new ClaimValidatorReport(writer, statistic, configuration));
        IDocumentAnalyser analyser = DefaultAnalyserFactory.createDefaultAnalyser(configuration);
        DefaultPolicy policy = new DefaultPolicy(configuration.getLicenseFamilies(LicenseSetFactory.LicenseFilter.APPROVED));
        IDocumentAnalyser[] analysers = new IDocumentAnalyser[]{analyser, policy};
        DocumentAnalyserMultiplexer analysisMultiplexer = new DocumentAnalyserMultiplexer(analysers);
        return new ClaimReporterMultiplexer(writer, configuration.isDryRun(), analysisMultiplexer, reporters);
    }
}

