/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.servant;

import jakarta.ejb.EJBHome;
import jakarta.jws.WebService;
import jakarta.resource.spi.work.WorkManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jca.cxf.WorkManagerThreadPool;
import org.apache.cxf.jca.servant.EJBInvoker;
import org.apache.cxf.jca.servant.EJBServantConfig;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.eclipse.jetty.util.thread.ThreadPool;

public class EJBEndpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(EJBEndpoint.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final String HTTPS_PREFIX = "https";
    private EJBServantConfig config;
    private Context jndiContext;
    private EJBHome ejbHome;
    private String ejbServantBaseURL;
    private WorkManager workManager;

    public EJBEndpoint(EJBServantConfig ejbConfig) {
        this.config = ejbConfig;
    }

    public Server publish() throws Exception {
        this.jndiContext = new InitialContext();
        Object obj = this.jndiContext.lookup(this.config.getJNDIName());
        this.ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)obj, EJBHome.class);
        Class<?> interfaceClass = Class.forName(this.getServiceClassName());
        boolean isJaxws = EJBEndpoint.isJaxWsServiceInterface(interfaceClass);
        JaxWsServerFactoryBean factory = isJaxws ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        factory.setServiceClass(interfaceClass);
        if (this.config.getWsdlURL() != null) {
            factory.getServiceFactory().setWsdlURL(this.config.getWsdlURL());
        }
        factory.setInvoker((Invoker)new EJBInvoker(this.ejbHome));
        String baseAddress = EJBEndpoint.isNotNull(this.getEjbServantBaseURL()) ? this.getEjbServantBaseURL() : this.getDefaultEJBServantBaseURL();
        String address = baseAddress + "/" + this.config.getJNDIName();
        factory.setAddress(address);
        if (address.length() >= 5 && HTTPS_PREFIX.equalsIgnoreCase(address.substring(0, 5))) {
            throw new UnsupportedOperationException("EJBEndpoint creation by https protocol is unsupported");
        }
        if (this.getWorkManager() != null) {
            this.setWorkManagerThreadPoolToJetty(factory.getBus(), baseAddress);
        }
        Server server = factory.create();
        LOG.info("Published EJB Endpoint of [" + this.config.getJNDIName() + "] at [" + address + "]");
        return server;
    }

    protected void setWorkManagerThreadPoolToJetty(Bus bus, String baseAddress) {
        int port;
        JettyHTTPServerEngineFactory engineFactory = (JettyHTTPServerEngineFactory)bus.getExtension(JettyHTTPServerEngineFactory.class);
        if (engineFactory.retrieveJettyHTTPServerEngine(port = this.getAddressPort(baseAddress)) != null) {
            return;
        }
        JettyHTTPServerEngine engine = new JettyHTTPServerEngine();
        engine.setThreadPool((ThreadPool)new WorkManagerThreadPool(this.getWorkManager()));
        engine.setPort(port);
        ArrayList<JettyHTTPServerEngine> engineList = new ArrayList<JettyHTTPServerEngine>();
        engineList.add(engine);
        engineFactory.setEnginesList(engineList);
    }

    public String getServiceClassName() throws Exception {
        String packageName = PackageUtils.parsePackageName((String)this.config.getServiceName().getNamespaceURI(), null);
        return packageName + "." + this.config.getJNDIName().substring(0, this.config.getJNDIName().length() - 4);
    }

    public String getDefaultEJBServantBaseURL() throws Exception {
        String hostName;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        return "http://" + hostName + ":9999";
    }

    public int getAddressPort(String address) {
        int index = address.lastIndexOf(58);
        int end = address.lastIndexOf(47);
        if (index == 4) {
            return 80;
        }
        if (end < index) {
            return Integer.parseInt(address.substring(index + 1));
        }
        return Integer.parseInt(address.substring(index + 1, end));
    }

    private static boolean isJaxWsServiceInterface(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return null != cls.getAnnotation(WebService.class);
    }

    public String getEjbServantBaseURL() {
        return this.ejbServantBaseURL;
    }

    public void setEjbServantBaseURL(String ejbServantBaseURL) {
        this.ejbServantBaseURL = ejbServantBaseURL;
    }

    private static boolean isNotNull(String value) {
        return value != null && !"".equals(value.trim());
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }
}

