/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestProxy;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletResponseProxy;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.PreviousEventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public abstract class AbstractProfileAction
extends AbstractInitializableComponent
implements ProfileAction {
    private final Logger log = LoggerFactory.getLogger(AbstractProfileAction.class);
    @Nullable
    private String logPrefix;
    @Nullable
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;
    @Nullable
    private NonnullSupplier<HttpServletResponse> httpServletResponseSupplier;

    @Nullable
    public HttpServletRequest getHttpServletRequest() {
        if (this.httpServletRequestSupplier == null) {
            return null;
        }
        return (HttpServletRequest)this.httpServletRequestSupplier.get();
    }

    @Nullable
    public NonnullSupplier<HttpServletRequest> getHttpServletRequestSupplier() {
        return this.httpServletRequestSupplier;
    }

    @Deprecated(since="4.3", forRemoval=true)
    public void setHttpServletRequest(final @Nullable HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (request != null && !(request instanceof ThreadLocalHttpServletRequestProxy)) {
            this.log.warn("Unsafe HttpServletRequest injected");
        }
        this.httpServletRequestSupplier = new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return request;
            }
        };
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletRequestSupplier = requestSupplier;
    }

    @Nullable
    public HttpServletResponse getHttpServletResponse() {
        if (this.httpServletResponseSupplier == null) {
            return null;
        }
        return (HttpServletResponse)this.httpServletResponseSupplier.get();
    }

    @Nullable
    public NonnullSupplier<HttpServletResponse> getHttpServletResponseSupplier() {
        return this.httpServletResponseSupplier;
    }

    @Deprecated(since="4.3", forRemoval=true)
    public void setHttpServletResponse(final @Nullable HttpServletResponse response) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (response != null && !(response instanceof ThreadLocalHttpServletResponseProxy)) {
            this.log.warn("Unsafe HttpServletRequest injected");
        }
        this.httpServletResponseSupplier = new NonnullSupplier<HttpServletResponse>(){

            public HttpServletResponse get() {
                return response;
            }
        };
    }

    public void setHttpServletResponseSupplier(@Nullable NonnullSupplier<HttpServletResponse> supplier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletResponseSupplier = supplier;
    }

    @Override
    public void execute(@Nonnull ProfileRequestContext profileRequestContext) {
        EventContext previousEvent = (EventContext)profileRequestContext.getSubcontext(EventContext.class);
        if (previousEvent != null) {
            ((PreviousEventContext)profileRequestContext.getSubcontext(PreviousEventContext.class, true)).setEvent(previousEvent.getEvent());
            profileRequestContext.removeSubcontext(EventContext.class);
        }
        if (this.doPreExecute(profileRequestContext)) {
            try {
                this.doExecute(profileRequestContext);
            }
            catch (Throwable t) {
                try {
                    if (t instanceof Exception) {
                        this.doPostExecute(profileRequestContext, (Exception)t);
                    } else {
                        this.doPostExecute(profileRequestContext);
                    }
                }
                catch (Throwable t2) {
                    LoggerFactory.getLogger(AbstractProfileAction.class).warn(this.getLogPrefix() + " Unchecked exception/error thrown by doPostInvoke, superseding earlier exception/error ", t);
                    t2.addSuppressed(t);
                    throw t2;
                }
                throw t;
            }
            this.doPostExecute(profileRequestContext);
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricContext metricCtx = (MetricContext)profileRequestContext.getSubcontext(MetricContext.class);
        if (metricCtx != null) {
            metricCtx.start(this.getClass().getSimpleName());
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
    }

    protected void doPostExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricContext metricCtx = (MetricContext)profileRequestContext.getSubcontext(MetricContext.class);
        if (metricCtx != null) {
            String name = this.getClass().getSimpleName();
            metricCtx.stop(name);
            metricCtx.inc(name);
        }
    }

    protected void doPostExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Exception e) {
        this.doPostExecute(profileRequestContext);
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = "Profile Action " + this.getClass().getSimpleName() + ":";
        }
        return this.logPrefix;
    }
}

