/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.server;

import java.util.Arrays;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerLogger;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class ActiveMQJMSServerLogger_impl
implements ActiveMQJMSServerLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQJMSServerLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void serverCachingCommand(Object runnable) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ121004: JMS Server Manager Caching command for {} since the JMS Server is not active.", runnable);
        }
    }

    @Override
    public void invalidHostForConnector(String name, String newHost) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ122005: Invalid \"host\" value \"0.0.0.0\" detected for \"{}\" connector. Switching to \"{}\". If this new address is incorrect please manually configure the connector to use the proper one.", (Object)name, (Object)newHost);
        }
    }

    @Override
    public void noQueueOnTopic(String queueName, String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ122007: Queue {} does not exist on the topic {}. It was deleted manually probably.", (Object)queueName, (Object)name);
        }
    }

    @Override
    public void bindingsUnbindError(String key, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ122011: error unbinding {} from Registry", (Object)key, (Object)e);
        }
    }

    @Override
    public void jmsServerError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ122012: JMS Server Manager error", (Throwable)e);
        }
    }

    @Override
    public void failedToCorrectHost(String name, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ122017: Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{}\" connector, but received an exception.", (Object)name, (Object)e);
        }
    }

    @Override
    public void failedToSendNotification(String notification) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ122018: Failed to send notification: {}", (Object)notification);
        }
    }

    @Override
    public void failedToDeactivateServer(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ122019: Unable to deactivate server", (Throwable)e);
        }
    }

    @Override
    public void serverRunningCachedCommand(Runnable run) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ123000: JMS Server Manager Running cached command for {}.(In the event of failover after failback has occurred, this message may be output multiple times.)", (Object)run);
        }
    }

    @Override
    public void jmsConfigMissingKey(Node e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ124000: key attribute missing for JMS configuration {}", (Object)e);
        }
    }

    @Override
    public void jmsDeployerStartError(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ124002: Failed to start JMS deployer", (Throwable)e);
        }
    }
}

