/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.MaybeBoolean$;
import org.apache.daffodil.lib.util.OKOrError$;
import org.apache.daffodil.runtime1.dpath.DFDLCheckConstraintsFunction$;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.parsers.CombinatorParser;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.validation.DaffodilValidator$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class ElementParserBase
extends CombinatorParser {
    private final ElementRuntimeData erd;
    private final String name;
    private final Object patDiscrimParser;
    private final Parser[] patAssertParser;
    private final Parser[] setVarParser;
    private final Object testDiscrimParser;
    private final Parser[] testAssertParser;
    private final Object eBeforeParser;
    private final Object eParser;
    private final Object eAfterParser;
    private final Object eRepTypeParser;

    public ElementParserBase(ElementRuntimeData erd, String name, Object patDiscrimParser, Parser[] patAssertParser, Parser[] setVarParser, Object testDiscrimParser, Parser[] testAssertParser, Object eBeforeParser, Object eParser, Object eAfterParser, Object eRepTypeParser) {
        this.erd = erd;
        this.name = name;
        this.patDiscrimParser = patDiscrimParser;
        this.patAssertParser = patAssertParser;
        this.setVarParser = setVarParser;
        this.testDiscrimParser = testDiscrimParser;
        this.testAssertParser = testAssertParser;
        this.eBeforeParser = eBeforeParser;
        this.eParser = eParser;
        this.eAfterParser = eAfterParser;
        this.eRepTypeParser = eRepTypeParser;
        super(erd);
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public abstract void move(PState var1);

    public abstract void parseBegin(PState var1);

    public abstract void parseEnd(PState var1);

    @Override
    public Vector<Processor> childProcessors() {
        return ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)Maybe$.MODULE$.toSeq$extension(this.patDiscrimParser).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.patAssertParser))).$plus$plus(Maybe$.MODULE$.toSeq$extension(this.eBeforeParser))).$plus$plus(Maybe$.MODULE$.toSeq$extension(this.eParser))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.setVarParser))).$plus$plus(Maybe$.MODULE$.toSeq$extension(this.testDiscrimParser))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.testAssertParser))).$plus$plus(Maybe$.MODULE$.toSeq$extension(this.eAfterParser))).$plus$plus(Maybe$.MODULE$.toSeq$extension(this.eRepTypeParser))).toVector();
    }

    @Override
    public String toBriefXML(int depthLimit) {
        if (depthLimit == 0) {
            return "...";
        }
        return "<Element name='" + this.name + "'>" + ((IterableOnceOps)this.childProcessors().map((Function1 & Serializable)_$2 -> _$2.toBriefXML(depthLimit - 1))).mkString() + "</Element>";
    }

    @Override
    public int toBriefXML$default$1() {
        return -1;
    }

    public PState validate(PState pstate) {
        PState pState;
        DIElement currentElement = pstate.thisElement();
        if (MaybeBoolean$.MODULE$.isDefined$extension(currentElement.valid())) {
            return pstate;
        }
        String ccfResult = DFDLCheckConstraintsFunction$.MODULE$.validate(pstate);
        if (OKOrError$.MODULE$.isOK$extension(ccfResult)) {
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Validation succeeded for {}", (Object)currentElement.namedQName());
            }
            currentElement.setValid(true);
            pState = pstate;
        } else {
            String failureMessage = ccfResult;
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Validation failed for ${context.toString} due to ${failureMessage}. The element was ${currentElement.namedQName}.");
            }
            pstate.validationError("%s failed facet checks due to: %s", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.context().toString(), failureMessage}));
            currentElement.setValid(false);
            pState = pstate;
        }
        PState resultState = pState;
        return resultState;
    }

    @Override
    public void parse(PState pstate) {
        block29: {
            block28: {
                if (Maybe$.MODULE$.isDefined$extension(this.patDiscrimParser)) {
                    ((Parser)Maybe$.MODULE$.get$extension(this.patDiscrimParser)).parse1(pstate);
                    if (pstate.processorStatus() != Success$.MODULE$) {
                        return;
                    }
                } else if (this.patAssertParser.length > 0) {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])this.patAssertParser);
                    int size = ArrayOps$.MODULE$.size$extension(object);
                    for (int i = 0; i < size; ++i) {
                        Parser d = this.patAssertParser[i];
                        d.parse1(pstate);
                        if (pstate.processorStatus() == Success$.MODULE$) continue;
                        return;
                    }
                }
                this.parseBegin(pstate);
                try {
                    Object object;
                    Object object2;
                    boolean shouldValidate;
                    if (pstate.processorStatus() != Success$.MODULE$) {
                        break block28;
                    }
                    if (Maybe$.MODULE$.isDefined$extension(this.eBeforeParser)) {
                        ((Parser)Maybe$.MODULE$.get$extension(this.eBeforeParser)).parse1(pstate);
                    }
                    if (pstate.processorStatus() != Success$.MODULE$) {
                        break block28;
                    }
                    Object object3 = pstate.dataProc();
                    if (Maybe$.MODULE$.isDefined$extension(object3)) {
                        Object object4 = pstate.dataProc();
                        ((DataProcessor)Maybe$.MODULE$.value$extension(object4)).startElement(pstate, this);
                    }
                    if (Maybe$.MODULE$.isDefined$extension(this.eRepTypeParser)) {
                        ((Parser)Maybe$.MODULE$.get$extension(this.eRepTypeParser)).parse1(pstate);
                    } else if (Maybe$.MODULE$.isDefined$extension(this.eParser)) {
                        ((Parser)Maybe$.MODULE$.get$extension(this.eParser)).parse1(pstate);
                    }
                    if (!pstate.hasInfoset()) {
                        throw Assert$.MODULE$.abort("Invariant broken: pstate.hasInfoset");
                    }
                    Seq<Diagnostic> setVarFailureDiags = package$.MODULE$.Nil();
                    if (pstate.processorStatus() == Success$.MODULE$) {
                        for (int i = 0; i < this.setVarParser.length; ++i) {
                            Parser d = this.setVarParser[i];
                            d.parse1(pstate);
                            if (pstate.processorStatus() == Success$.MODULE$) continue;
                            setVarFailureDiags = pstate.diagnostics();
                        }
                    }
                    if (Maybe$.MODULE$.isDefined$extension(this.testDiscrimParser)) {
                        ((Parser)Maybe$.MODULE$.get$extension(this.testDiscrimParser)).parse1(pstate);
                        if (pstate.processorStatus() != Success$.MODULE$) {
                            break block28;
                        }
                    }
                    if (setVarFailureDiags.nonEmpty()) {
                        pstate.setFailed((Diagnostic)setVarFailureDiags.head());
                        break block28;
                    }
                    if (pstate.processorStatus() != Success$.MODULE$) {
                        break block28;
                    }
                    for (int i = 0; i < this.testAssertParser.length; ++i) {
                        Parser d = this.testAssertParser[i];
                        d.parse1(pstate);
                        if (pstate.processorStatus() == Success$.MODULE$) continue;
                        break block28;
                    }
                    if (Maybe$.MODULE$.isDefined$extension(this.eAfterParser)) {
                        ((Parser)Maybe$.MODULE$.get$extension(this.eAfterParser)).parse1(pstate);
                    }
                    if (pstate.processorStatus() != Success$.MODULE$) {
                        break block28;
                    }
                    boolean bl = shouldValidate = this.erd.isSimpleType() && Maybe$.MODULE$.isDefined$extension(object2 = pstate.dataProc()) && ((DataProcessor)Maybe$.MODULE$.value$extension(object = pstate.dataProc())).validator() == DaffodilValidator$.MODULE$;
                    if (shouldValidate) {
                        this.validate(pstate);
                    }
                    pstate.infoset().setFinal();
                    break block29;
                }
                finally {
                    this.parseEnd(pstate);
                    Object object = pstate.dataProc();
                    if (Maybe$.MODULE$.isDefined$extension(object)) {
                        Object object5 = pstate.dataProc();
                        ((DataProcessor)Maybe$.MODULE$.value$extension(object5)).endElement(pstate, this);
                    }
                }
            }
            return;
        }
    }
}

