/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.MemorySegmentHashIterator;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.ThetaSketch;

class DirectCompactSketch
extends CompactThetaSketch {
    final MemorySegment seg_;

    DirectCompactSketch(MemorySegment seg) {
        this.seg_ = seg;
    }

    static DirectCompactSketch wrapInstance(MemorySegment srcSeg, short seedHash) {
        Util.checkSeedHashes((short)PreambleUtil.extractSeedHash(srcSeg), seedHash);
        return new DirectCompactSketch(srcSeg);
    }

    @Override
    public CompactThetaSketch compact(boolean dstOrdered, MemorySegment dstSeg) {
        return CompactOperations.segmentToCompact(this.seg_, dstOrdered, dstSeg);
    }

    @Override
    public int getCurrentBytes() {
        if (SingleItemSketch.checkForSingleItem(this.seg_)) {
            return 16;
        }
        int preLongs = ThetaSketch.getPreambleLongs(this.seg_);
        int curCount = preLongs == 1 ? 0 : PreambleUtil.extractCurCount(this.seg_);
        return preLongs + curCount << 3;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        if (SingleItemSketch.checkForSingleItem(this.seg_)) {
            return 1;
        }
        int preLongs = ThetaSketch.getPreambleLongs(this.seg_);
        return preLongs == 1 ? 0 : PreambleUtil.extractCurCount(this.seg_);
    }

    @Override
    public long getThetaLong() {
        int preLongs = ThetaSketch.getPreambleLongs(this.seg_);
        return preLongs > 2 ? PreambleUtil.extractThetaLong(this.seg_) : Long.MAX_VALUE;
    }

    @Override
    public boolean hasMemorySegment() {
        return this.seg_ != null && this.seg_.scope().isAlive();
    }

    @Override
    public boolean isOffHeap() {
        return this.hasMemorySegment() && this.seg_.isNative();
    }

    @Override
    public boolean isEmpty() {
        boolean emptyFlag = PreambleUtil.isEmptyFlag(this.seg_);
        long thetaLong = this.getThetaLong();
        int curCount = this.getRetainedEntries(true);
        return emptyFlag || curCount == 0 && thetaLong == Long.MAX_VALUE;
    }

    @Override
    public boolean isOrdered() {
        return (PreambleUtil.extractFlags(this.seg_) & 0x10) > 0;
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return this.hasMemorySegment() && MemorySegmentStatus.isSameResource(this.seg_, that);
    }

    @Override
    public HashIterator iterator() {
        return new MemorySegmentHashIterator(this.seg_, this.getRetainedEntries(true), this.getThetaLong());
    }

    @Override
    public byte[] toByteArray() {
        CompactOperations.checkIllegalCurCountAndEmpty(this.isEmpty(), this.getRetainedEntries());
        int outBytes = this.getCurrentBytes();
        byte[] byteArrOut = new byte[outBytes];
        MemorySegment.copy(this.seg_, ValueLayout.JAVA_BYTE, 0L, byteArrOut, 0, outBytes);
        return byteArrOut;
    }

    @Override
    long[] getCache() {
        int curCount;
        if (SingleItemSketch.checkForSingleItem(this.seg_)) {
            return new long[]{this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L)};
        }
        int preLongs = ThetaSketch.getPreambleLongs(this.seg_);
        int n = curCount = preLongs == 1 ? 0 : PreambleUtil.extractCurCount(this.seg_);
        if (curCount > 0) {
            long[] cache = new long[curCount];
            MemorySegment.copy(this.seg_, ValueLayout.JAVA_LONG_UNALIGNED, preLongs << 3, cache, 0, curCount);
            return cache;
        }
        return new long[0];
    }

    @Override
    int getCompactPreambleLongs() {
        return ThetaSketch.getPreambleLongs(this.seg_);
    }

    @Override
    int getCurrentPreambleLongs() {
        return ThetaSketch.getPreambleLongs(this.seg_);
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.seg_;
    }

    @Override
    short getSeedHash() {
        return (short)PreambleUtil.extractSeedHash(this.seg_);
    }
}

