/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.felix.webconsole.servlet.RequestVariableResolver;

public abstract class AbstractServlet
extends HttpServlet {
    protected URL getResource(String path) {
        int index = path.indexOf(47, 1);
        if (index != -1 && path.substring(index).startsWith("/res/")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(index));
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.spoolResource(request, response);
    }

    public void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new ServletException("Render method not implemented");
    }

    protected final void spoolResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URL url = this.getResource(request.getPathInfo());
        if (url == null) {
            return;
        }
        URLConnection connection = url.openConnection();
        try (InputStream ins = connection.getInputStream();){
            int rd;
            if (ins == null) {
                return;
            }
            long lastModified = connection.getLastModified();
            if (lastModified > 0L) {
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (ifModifiedSince >= lastModified / 1000L * 1000L) {
                    response.setStatus(304);
                    return;
                }
                response.setDateHeader("Last-Modified", lastModified);
            }
            response.setContentType(this.getServletContext().getMimeType(request.getPathInfo()));
            if (connection.getContentLength() != -1) {
                response.setContentLength(connection.getContentLength());
            }
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            byte[] buf = new byte[2048];
            while ((rd = ins.read(buf)) >= 0) {
                out.write(buf, 0, rd);
            }
        }
    }

    protected final String readTemplateFile(String templateFile) throws IOException {
        return this.readTemplateFile(((Object)((Object)this)).getClass(), templateFile);
    }

    /*
     * Exception decompiling
     */
    private final String readTemplateFile(Class<?> clazz, String templateFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected RequestVariableResolver getVariableResolver(HttpServletRequest request) {
        return (RequestVariableResolver)request.getAttribute("felix.webconsole.variable.resolver");
    }

    public static final void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Cache-Control", "max-age=0");
        response.setHeader("Expires", "Thu, 01 Jan 1970 01:00:00 GMT");
        response.setHeader("Pragma", "no-cache");
    }
}

