/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.config;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class MaterializedTableConfigOptions {
    public static final String PARTITION_FIELDS = "partition.fields";
    public static final String DATE_FORMATTER = "date-formatter";
    public static final String SCHEDULE_TIME_DATE_FORMATTER_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Duration> MATERIALIZED_TABLE_FRESHNESS_THRESHOLD = ConfigOptions.key((String)"materialized-table.refresh-mode.freshness-threshold").durationType().defaultValue((Object)Duration.ofMinutes(30L)).withDescription("Specifies a time threshold for determining the materialized table refresh mode. If the materialized table defined FRESHNESS is below this threshold, it run in continuous mode. Otherwise, it switches to full refresh mode.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<String> PARTITION_FIELDS_DATE_FORMATTER = ConfigOptions.key((String)String.format("%s.#.%s", "partition.fields", "date-formatter")).stringType().noDefaultValue().withDescription("Specifies the time partition formatter for the partitioned materialized table, where '#' denotes a string-based partition field name. This serves as a hint to the framework regarding which partition to refresh in full refresh mode.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Duration> MATERIALIZED_TABLE_DEFAULT_FRESHNESS_CONTINUOUS = ConfigOptions.key((String)"materialized-table.default-freshness.continuous").durationType().defaultValue((Object)Duration.ofMinutes(3L)).withDescription("The default freshness interval for continuous refresh mode when the FRESHNESS clause is omitted in a materialized table definition.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Duration> MATERIALIZED_TABLE_DEFAULT_FRESHNESS_FULL = ConfigOptions.key((String)"materialized-table.default-freshness.full").durationType().defaultValue((Object)Duration.ofHours(1L)).withDescription("The default freshness interval for full refresh mode when the FRESHNESS clause is omitted in a materialized table definition.");

    private MaterializedTableConfigOptions() {
    }
}

