/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.util.Preconditions;

@Internal
public class DefaultExpressionEvaluator
implements SpecializedFunction.ExpressionEvaluator {
    private static final long serialVersionUID = 1L;
    private final GeneratedFunction<RichFunction> generatedClass;
    private final MethodType methodType;
    private final String expressionSummary;
    private transient RichFunction instance;

    public DefaultExpressionEvaluator(GeneratedFunction<RichFunction> generatedClass, Class<?> returnClass, Class<?>[] argClasses, String expressionSummary) {
        this.generatedClass = generatedClass;
        this.methodType = MethodType.methodType(returnClass, argClasses);
        this.expressionSummary = expressionSummary;
    }

    public MethodHandle open(FunctionContext context) {
        Preconditions.checkState((this.instance == null ? 1 : 0) != 0, (String)"Expression evaluator for '%s' has already been opened.", (Object[])new Object[]{this.expressionSummary});
        try {
            this.instance = (RichFunction)this.generatedClass.newInstance(context.getUserCodeClassLoader());
            this.instance.open(DefaultOpenContext.INSTANCE);
            MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
            return publicLookup.findVirtual(this.instance.getClass(), "eval", this.methodType).bindTo(this.instance);
        }
        catch (Exception e) {
            throw new TableException(String.format("Expression evaluator for '%s' could not be opened.", this.expressionSummary), (Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.instance != null) {
                this.instance.close();
            }
        }
        catch (Exception e) {
            throw new TableException(String.format("Expression evaluator for '%s' could not be closed.", this.expressionSummary), (Throwable)e);
        }
    }

    public String toString() {
        return String.format("ExpressionEvaluator{handleSignature=%s, expression=%s}", this.methodType, this.expressionSummary);
    }
}

