/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#ifndef GEODE_LOCATORLISTRESPONSE_H_
#define GEODE_LOCATORLISTRESPONSE_H_

#include <vector>

#include "ServerLocation.hpp"
#include "ServerLocationResponse.hpp"

namespace apache {
namespace geode {
namespace client {

using internal::DSFid;

class DataInput;

class LocatorListResponse : public ServerLocationResponse {
 private:
  std::vector<ServerLocation> m_locators;
  bool m_isBalanced;
  void readList(DataInput& input);

 public:
  LocatorListResponse() : m_isBalanced(false) {}
  ~LocatorListResponse() override = default;

  void fromData(DataInput& input) override;
  DSFid getDSFID() const override;

  const std::vector<ServerLocation>& getLocators() const;
  bool isBalanced() const;
  static std::shared_ptr<Serializable> create();
};

}  // namespace client
}  // namespace geode
}  // namespace apache

#endif  // GEODE_LOCATORLISTRESPONSE_H_
