/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.toml;

import com.fasterxml.jackson.core.JsonStreamContext;

final class TomlWriteContext
extends JsonStreamContext {
    protected final TomlWriteContext _parent;
    protected TomlWriteContext _child = null;
    protected Object _currentValue;
    protected boolean _gotName;
    protected String _currentName;
    protected int _basePathLength;
    boolean _inline;

    TomlWriteContext(int type, TomlWriteContext parent, Object currValue, int basePathLength) {
        this._type = type;
        this._parent = parent;
        this._nestingDepth = parent == null ? 0 : parent._nestingDepth + 1;
        this._basePathLength = basePathLength;
        this._index = -1;
        this._currentValue = currValue;
        this._inline = type == 1 || parent != null && parent._inline;
    }

    private void reset(int type, Object currValue, int basePathLength) {
        this._type = type;
        this._basePathLength = basePathLength;
        this._currentValue = null;
        this._index = -1;
        this._currentValue = currValue;
        this._inline = type == 1 || this._parent != null && this._parent._inline;
    }

    static TomlWriteContext createRootContext() {
        return new TomlWriteContext(0, null, null, 0);
    }

    static TomlWriteContext createRootContext(int basePathLength) {
        return new TomlWriteContext(0, null, null, basePathLength);
    }

    public TomlWriteContext createChildArrayContext(Object currValue, int basePathLength) {
        TomlWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new TomlWriteContext(1, this, currValue, basePathLength);
            return ctxt;
        }
        ctxt.reset(1, currValue, basePathLength);
        return ctxt;
    }

    public TomlWriteContext createChildObjectContext(Object currValue, int basePathLength) {
        TomlWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new TomlWriteContext(2, this, currValue, basePathLength);
            return ctxt;
        }
        ctxt.reset(2, currValue, basePathLength);
        return ctxt;
    }

    public boolean writeName(String name) {
        if (this._gotName) {
            return false;
        }
        this._gotName = true;
        this._currentName = name;
        return true;
    }

    public boolean writeValue() {
        if (this._type == 2) {
            if (!this._gotName) {
                return false;
            }
            this._gotName = false;
        }
        ++this._index;
        return true;
    }

    public void truncatePath(StringBuilder sb) {
        int len = sb.length();
        if (len != this._basePathLength) {
            if (len < this._basePathLength) {
                throw new IllegalStateException(String.format("Internal error: base path length %d, buffered %d, trying to truncate", this._basePathLength, len));
            }
            sb.setLength(this._basePathLength);
        }
    }

    public final TomlWriteContext getParent() {
        return this._parent;
    }

    public String getCurrentName() {
        return this._currentName;
    }

    public Object getCurrentValue() {
        return this._currentValue;
    }

    public void setCurrentValue(Object v) {
        this._currentValue = v;
    }

    public StringBuilder appendDesc(StringBuilder sb) {
        if (this._parent != null) {
            sb = this._parent.appendDesc(sb);
            sb.append('/');
        }
        switch (this._type) {
            case 2: {
                if (this._currentName == null) break;
                sb.append(this._currentName);
                break;
            }
            case 1: {
                sb.append(this.getCurrentIndex());
                break;
            }
        }
        return sb;
    }

    public final String toString() {
        return this.appendDesc(new StringBuilder(64)).toString();
    }
}

