/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.Arrays;
import org.testng.IExpectedExceptionsHolder;
import org.testng.ITestNGMethod;
import org.testng.TestException;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;

public class ExpectedExceptionsHolder {
    protected final IAnnotationFinder finder;
    protected final ITestNGMethod method;
    private final Class<?>[] expectedClasses;
    private final IExpectedExceptionsHolder holder;

    protected ExpectedExceptionsHolder(IAnnotationFinder finder, ITestNGMethod method, IExpectedExceptionsHolder holder) {
        this.finder = finder;
        this.method = method;
        this.expectedClasses = ExpectedExceptionsHolder.findExpectedClasses(finder, method);
        this.holder = holder;
    }

    private static Class<?>[] findExpectedClasses(IAnnotationFinder finder, ITestNGMethod method) {
        ITestAnnotation testAnnotation = finder.findAnnotation(method, ITestAnnotation.class);
        if (testAnnotation != null) {
            return testAnnotation.getExpectedExceptions();
        }
        return new Class[0];
    }

    public boolean isExpectedException(Throwable ite) {
        if (this.hasNoExpectedClasses()) {
            return false;
        }
        if (ite.getClass() == TestException.class) {
            return false;
        }
        Class<?> realExceptionClass = ite.getClass();
        for (Class<?> exception : this.expectedClasses) {
            if (!exception.isAssignableFrom(realExceptionClass) || !this.holder.isThrowableMatching(ite)) continue;
            return true;
        }
        return false;
    }

    public Throwable wrongException(Throwable ite) {
        if (this.hasNoExpectedClasses()) {
            return ite;
        }
        if (this.holder.isThrowableMatching(ite)) {
            return new TestException("Expected exception of " + this.getExpectedExceptionsPluralize() + " but got " + ite, ite);
        }
        return new TestException(this.holder.getWrongExceptionMessage(ite), ite);
    }

    public TestException noException(ITestNGMethod testMethod) {
        if (this.hasNoExpectedClasses()) {
            return null;
        }
        return new TestException("Method " + testMethod + " should have thrown an exception of " + this.getExpectedExceptionsPluralize());
    }

    private boolean hasNoExpectedClasses() {
        return this.expectedClasses == null || this.expectedClasses.length == 0;
    }

    private String getExpectedExceptionsPluralize() {
        StringBuilder sb = new StringBuilder();
        if (this.expectedClasses.length > 1) {
            sb.append("any of types ");
            sb.append(Arrays.toString(this.expectedClasses));
        } else {
            sb.append("type ");
            sb.append(this.expectedClasses[0]);
        }
        return sb.toString();
    }
}

