/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.WritableByteChannelMock;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.CodecTestUtils;
import org.apache.hc.core5.http.impl.nio.LengthDelimitedEncoder;
import org.apache.hc.core5.http.impl.nio.SessionOutputBufferImpl;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestLengthDelimitedEncoder {
    private File tmpfile;

    TestLengthDelimitedEncoder() {
    }

    protected File createTempFile() throws IOException {
        this.tmpfile = File.createTempFile("testFile", ".txt");
        return this.tmpfile;
    }

    @AfterEach
    void deleteTempFile() {
        if (this.tmpfile != null && this.tmpfile.exists()) {
            this.tmpfile.delete();
        }
    }

    @Test
    void testBasicCoding() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 16L);
        encoder.write(CodecTestUtils.wrap("stuff;"));
        encoder.write(CodecTestUtils.wrap("more stuff"));
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"stuff;more stuff", (Object)s);
        Assertions.assertEquals((Object)"[content length: 16; pos: 16; completed: true]", (Object)encoder.toString());
    }

    @Test
    void testCodingBeyondContentLimit() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 16L);
        encoder.write(CodecTestUtils.wrap("stuff;"));
        encoder.write(CodecTestUtils.wrap("more stuff; and a lot more stuff"));
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"stuff;more stuff", (Object)s);
    }

    @Test
    void testCodingEmptyBuffer() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 16L);
        encoder.write(CodecTestUtils.wrap("stuff;"));
        ByteBuffer empty = ByteBuffer.allocate(100);
        empty.flip();
        encoder.write(empty);
        encoder.write(null);
        encoder.write(CodecTestUtils.wrap("more stuff"));
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"stuff;more stuff", (Object)s);
    }

    @Test
    void testCodingCompleted() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 5L);
        encoder.write(CodecTestUtils.wrap("stuff"));
        ByteBuffer wrapped = CodecTestUtils.wrap("more stuff");
        Assertions.assertThrows(IllegalStateException.class, () -> encoder.write(wrapped));
    }

    @Test
    void testInvalidConstructor() {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        Assertions.assertThrows(NullPointerException.class, () -> new LengthDelimitedEncoder(null, null, null, 10L));
        Assertions.assertThrows(NullPointerException.class, () -> new LengthDelimitedEncoder((WritableByteChannel)channel, null, null, 10L));
        Assertions.assertThrows(NullPointerException.class, () -> TestLengthDelimitedEncoder.lambda$testInvalidConstructor$3(channel, (SessionOutputBuffer)outbuf));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TestLengthDelimitedEncoder.lambda$testInvalidConstructor$4(channel, (SessionOutputBuffer)outbuf, metrics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCodingBeyondContentLimitFromFile() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 16L);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            testfile.write("stuff;".getBytes(StandardCharsets.US_ASCII));
            testfile.write("more stuff; and a lot more stuff".getBytes(StandardCharsets.US_ASCII));
        }
        testfile = new RandomAccessFile(this.tmpfile, "rw");
        try {
            FileChannel fchannel = testfile.getChannel();
            encoder.transfer(fchannel, 0L, 20L);
        }
        finally {
            testfile.close();
        }
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"stuff;more stuff", (Object)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCodingEmptyFile() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 16L);
        encoder.write(CodecTestUtils.wrap("stuff;"));
        this.createTempFile();
        RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");
        testfile.close();
        testfile = new RandomAccessFile(this.tmpfile, "rw");
        try {
            FileChannel fchannel = testfile.getChannel();
            encoder.transfer(fchannel, 0L, 20L);
            encoder.write(CodecTestUtils.wrap("more stuff"));
        }
        finally {
            testfile.close();
        }
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"stuff;more stuff", (Object)s);
    }

    @Test
    void testCodingCompletedFromFile() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 5L);
        encoder.write(CodecTestUtils.wrap("stuff"));
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            testfile.write("more stuff".getBytes(StandardCharsets.US_ASCII));
        }
        var6_6 = null;
        try (RandomAccessFile file = new RandomAccessFile(this.tmpfile, "rw");
             FileChannel fchannel = file.getChannel();){
            Assertions.assertThrows(IllegalStateException.class, () -> encoder.transfer(fchannel, 0L, 10L));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCodingFromFileSmaller() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 16L);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            testfile.write("stuff;".getBytes(StandardCharsets.US_ASCII));
            testfile.write("more stuff".getBytes(StandardCharsets.US_ASCII));
        }
        testfile = new RandomAccessFile(this.tmpfile, "rw");
        try {
            FileChannel fchannel = testfile.getChannel();
            encoder.transfer(fchannel, 0L, 20L);
        }
        finally {
            testfile.close();
        }
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"stuff;more stuff", (Object)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCodingFromFileFlushBuffer() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 16L);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("header");
        outbuf.writeLine(chbuffer);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            testfile.write("stuff;".getBytes(StandardCharsets.US_ASCII));
            testfile.write("more stuff".getBytes(StandardCharsets.US_ASCII));
        }
        testfile = new RandomAccessFile(this.tmpfile, "rw");
        try {
            FileChannel fchannel = testfile.getChannel();
            encoder.transfer(fchannel, 0L, 20L);
        }
        finally {
            testfile.close();
        }
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"header\r\nstuff;more stuff", (Object)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCodingFromFileChannelSaturated() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64, 4);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 16L);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("header");
        outbuf.writeLine(chbuffer);
        this.createTempFile();
        try (RandomAccessFile testfile = new RandomAccessFile(this.tmpfile, "rw");){
            testfile.write("stuff".getBytes(StandardCharsets.US_ASCII));
        }
        testfile = new RandomAccessFile(this.tmpfile, "rw");
        try {
            FileChannel fchannel = testfile.getChannel();
            encoder.transfer(fchannel, 0L, 20L);
            encoder.transfer(fchannel, 0L, 20L);
        }
        finally {
            testfile.close();
        }
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertFalse((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"head", (Object)s);
    }

    @Test
    void testCodingNoFragmentBuffering() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("header");
        outbuf.writeLine(chbuffer);
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 0);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.never())).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)1))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)13L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"header\r\nstuff", (Object)s);
    }

    @Test
    void testCodingFragmentBuffering() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("header");
        outbuf.writeLine(chbuffer);
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 32);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.never())).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)0L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"header\r\nstuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingMultipleFragments() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 32);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)10, (int)encoder.write(CodecTestUtils.wrap("more stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.never())).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)0L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff-more stuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingMultipleFragmentsBeyondContentLimit() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 16L, 32);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)10, (int)encoder.write(CodecTestUtils.wrap("more stuff; and a lot more stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.never())).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)0L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff-more stuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingLargeFragment() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("header");
        outbuf.writeLine(chbuffer);
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 2);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.never())).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)1))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)13L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"header\r\nstuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingTinyFragments() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 1);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)10, (int)encoder.write(CodecTestUtils.wrap("more stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)5))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)3))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)18L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff---more stuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingTinyFragments2() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 2);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)10, (int)encoder.write(CodecTestUtils.wrap("more stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)4))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)2))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)18L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff---more stuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingTinyFragments3() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 3);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)2, (int)encoder.write(CodecTestUtils.wrap("--")));
        Assertions.assertEquals((int)10, (int)encoder.write(CodecTestUtils.wrap("more stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)4))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)5))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)2))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)21L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff------more stuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingBufferFlush() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 8);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)6, (int)encoder.write(CodecTestUtils.wrap("-stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)1))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)8L, (long)metrics.getBytesTransferred());
        Assertions.assertEquals((int)3, (int)outbuf.length());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff-stuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingBufferFlush2() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 8);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)16, (int)encoder.write(CodecTestUtils.wrap("-much more stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)1))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)21L, (long)metrics.getBytesTransferred());
        Assertions.assertEquals((int)0, (int)outbuf.length());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff-much more stuff", (Object)s);
    }

    @Test
    void testCodingFragmentBufferingChannelSaturated() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64, 8));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 3);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)0, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)0, (int)encoder.write(CodecTestUtils.wrap("more stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)5))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)6))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)4))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)8L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff---", (Object)s);
        Assertions.assertEquals((int)3, (int)outbuf.length());
    }

    @Test
    void testCodingFragmentBufferingChannelSaturated2() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(64, 8));
        SessionOutputBuffer outbuf = (SessionOutputBuffer)Mockito.spy((Object)new SessionOutputBufferImpl(1024, 128));
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        LengthDelimitedEncoder encoder = new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, 100L, 8);
        Assertions.assertEquals((int)5, (int)encoder.write(CodecTestUtils.wrap("stuff")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("-")));
        Assertions.assertEquals((int)1, (int)encoder.write(CodecTestUtils.wrap("much more stuff")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
        ((SessionOutputBuffer)Mockito.verify((Object)outbuf, (VerificationMode)Mockito.times((int)1))).flush((WritableByteChannel)channel);
        Assertions.assertEquals((long)8L, (long)metrics.getBytesTransferred());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"stuff--m", (Object)s);
        Assertions.assertEquals((int)0, (int)outbuf.length());
    }

    private static /* synthetic */ void lambda$testInvalidConstructor$4(WritableByteChannelMock channel, SessionOutputBuffer outbuf, BasicHttpTransportMetrics metrics) throws Throwable {
        new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, metrics, -10L);
    }

    private static /* synthetic */ void lambda$testInvalidConstructor$3(WritableByteChannelMock channel, SessionOutputBuffer outbuf) throws Throwable {
        new LengthDelimitedEncoder((WritableByteChannel)channel, outbuf, null, 10L);
    }
}

