/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.WaitMapExchangeFinishCallable;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.yardstickframework.BenchmarkConfiguration;

public class IgnitePutTxSkipLocalBackupBenchmark
extends IgniteCacheAbstractBenchmark {
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        if (!IgniteSystemProperties.getBoolean((String)"SKIP_MAP_CHECK")) {
            this.ignite().compute().broadcast((IgniteCallable)new WaitMapExchangeFinishCallable());
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        int key;
        IgniteCache cache = this.cacheForOperation();
        Affinity aff = this.ignite().affinity("tx");
        ClusterNode locNode = this.ignite().cluster().localNode();
        while (aff.isBackup(locNode, (Object)(key = IgnitePutTxSkipLocalBackupBenchmark.nextRandom(this.args.range())))) {
        }
        cache.put((Object)key, (Object)new SampleValue(key));
        return true;
    }

    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("tx");
    }
}

