/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.shaded.org.apache.ignite.internal.event.Event;
import org.apache.ignite.shaded.org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.shaded.org.apache.ignite.internal.event.EventParameters;
import org.apache.ignite.shaded.org.apache.ignite.internal.event.EventProducer;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.CompletableFutures;

public abstract class AbstractEventProducer<T extends Event, P extends EventParameters>
implements EventProducer<T, P> {
    private final ConcurrentHashMap<T, List<EventListener<P>>> listenersByEvent = new ConcurrentHashMap();

    @Override
    public void listen(T evt, EventListener<? extends P> listener) {
        this.listenersByEvent.compute(evt, (evt0, listeners) -> {
            ArrayList<EventListener> newListeners;
            if (listeners == null) {
                newListeners = new ArrayList<EventListener>(1);
            } else {
                newListeners = new ArrayList(listeners.size() + 1);
                newListeners.addAll((Collection<EventListener>)listeners);
            }
            newListeners.add(listener);
            return Collections.unmodifiableList(newListeners);
        });
    }

    @Override
    public void removeListener(T evt, EventListener<? extends P> listener) {
        this.listenersByEvent.computeIfPresent(evt, (evt0, listeners) -> {
            ArrayList newListeners = new ArrayList(listeners);
            newListeners.remove(listener);
            return newListeners.isEmpty() ? null : Collections.unmodifiableList(newListeners);
        });
    }

    protected CompletableFuture<Void> fireEvent(T evt, P params) {
        List<EventListener<P>> listeners = this.listenersByEvent.get(evt);
        if (listeners == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        ArrayList<CompletionStage> futures = null;
        for (int i = 0; i < listeners.size(); ++i) {
            EventListener<P> listener = listeners.get(i);
            CompletableFuture<Boolean> future = listener.notify(params);
            if (future.isDone() && !future.isCompletedExceptionally()) {
                if (!future.join().booleanValue()) continue;
                this.removeListener(evt, listener);
                continue;
            }
            if (futures == null) {
                futures = new ArrayList<CompletionStage>();
            }
            futures.add(future.thenAccept(remove -> {
                if (remove.booleanValue()) {
                    this.removeListener(evt, listener);
                }
            }));
        }
        return futures == null ? CompletableFutures.nullCompletedFuture() : CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }
}

