/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.set;

import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;

public interface IgniteMapSetOp
extends IgniteSetOp {
    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        if (inputTraits.stream().allMatch(t -> TraitUtils.distribution(t).satisfies((RelTrait)IgniteDistributions.single()))) {
            return List.of();
        }
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.random()), Commons.transform(inputTraits, t -> TraitUtils.distribution(t) == IgniteDistributions.broadcast() ? t.replace((RelTrait)IgniteDistributions.hash(List.of(Integer.valueOf(0)))) : t.replace((RelTrait)IgniteDistributions.random()))));
    }

    public static RelDataType buildRowType(IgniteTypeFactory typeFactory, RelDataType inputRowType, int inputsNum) {
        int i;
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        for (i = 0; i < inputRowType.getFieldCount(); ++i) {
            RelDataTypeField field = (RelDataTypeField)inputRowType.getFieldList().get(i);
            builder.add("f" + i, field.getType());
        }
        for (i = 0; i < inputsNum; ++i) {
            builder.add("_COUNT_" + i, typeFactory.createSqlType(SqlTypeName.INTEGER));
        }
        return builder.build();
    }

    @Override
    default public AggregateType aggregateType() {
        return AggregateType.MAP;
    }
}

