/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.pagemem.FullPageId;

class CheckpointPages {
    private final Collection<FullPageId> segCheckpointPages;
    private final IgniteInternalFuture allowToReplace;

    CheckpointPages(Collection<FullPageId> pages, IgniteInternalFuture replaceFuture) {
        this.segCheckpointPages = pages;
        this.allowToReplace = replaceFuture;
    }

    public boolean allowToSave(FullPageId fullPageId) throws IgniteCheckedException {
        Collection<FullPageId> checkpointPages = this.segCheckpointPages;
        if (checkpointPages == null || this.allowToReplace == null) {
            return false;
        }
        this.allowToReplace.getUninterruptibly();
        return checkpointPages.contains(fullPageId);
    }

    public boolean contains(FullPageId fullPageId) {
        Collection<FullPageId> checkpointPages = this.segCheckpointPages;
        return checkpointPages != null && checkpointPages.contains(fullPageId);
    }

    public boolean markAsSaved(FullPageId fullPageId) {
        Collection<FullPageId> checkpointPages = this.segCheckpointPages;
        return checkpointPages != null && checkpointPages.remove(fullPageId);
    }

    public int size() {
        Collection<FullPageId> checkpointPages = this.segCheckpointPages;
        return checkpointPages == null ? 0 : checkpointPages.size();
    }
}

