/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.appender.v1_0;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

class LoggingEventToReplay
implements ILoggingEvent {
    private final ILoggingEvent loggingEvent;
    private final long timeStamp;
    private StackTraceElement[] callerData;
    private String threadName;

    LoggingEventToReplay(ILoggingEvent loggingEvent, boolean captureExperimentalAttributes, boolean captureCodeAttributes) {
        this.loggingEvent = loggingEvent;
        this.timeStamp = loggingEvent.getTimeStamp();
        if (captureExperimentalAttributes) {
            this.threadName = loggingEvent.getThreadName();
        }
        if (captureCodeAttributes) {
            this.callerData = loggingEvent.getCallerData();
        }
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Level getLevel() {
        return this.loggingEvent.getLevel();
    }

    public String getMessage() {
        return this.loggingEvent.getMessage();
    }

    public Object[] getArgumentArray() {
        return this.loggingEvent.getArgumentArray();
    }

    public String getFormattedMessage() {
        return this.loggingEvent.getFormattedMessage();
    }

    public String getLoggerName() {
        return this.loggingEvent.getLoggerName();
    }

    public LoggerContextVO getLoggerContextVO() {
        return this.loggingEvent.getLoggerContextVO();
    }

    public IThrowableProxy getThrowableProxy() {
        return this.loggingEvent.getThrowableProxy();
    }

    public StackTraceElement[] getCallerData() {
        return this.callerData;
    }

    public boolean hasCallerData() {
        return this.loggingEvent.hasCallerData();
    }

    public Marker getMarker() {
        return this.loggingEvent.getMarker();
    }

    public List<Marker> getMarkerList() {
        return this.loggingEvent.getMarkerList();
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.loggingEvent.getMDCPropertyMap();
    }

    public Map<String, String> getMdc() {
        return this.loggingEvent.getMdc();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getNanoseconds() {
        return this.loggingEvent.getNanoseconds();
    }

    public long getSequenceNumber() {
        return this.loggingEvent.getSequenceNumber();
    }

    public List<KeyValuePair> getKeyValuePairs() {
        return this.loggingEvent.getKeyValuePairs();
    }

    public void prepareForDeferredProcessing() {
        this.loggingEvent.prepareForDeferredProcessing();
    }
}

