/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.value.ClickHouseEmptyValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@FunctionalInterface
public interface ClickHouseDeserializer {
    public static final ClickHouseDeserializer EMPTY_VALUE = (v, i) -> ClickHouseEmptyValue.INSTANCE;
    public static final ClickHouseDeserializer NOT_SUPPORTED = (v, i) -> {
        throw new IOException("Deserialization is not supported");
    };
    public static final String TYPE_NAME = "Deserializer";

    public static ClickHouseDeserializer of(ClickHouseDeserializer first, ClickHouseDeserializer ... more) {
        LinkedList<ClickHouseDeserializer> list = new LinkedList<ClickHouseDeserializer>();
        if (first != null) {
            list.add(first);
        }
        if (more != null) {
            for (ClickHouseDeserializer d : more) {
                if (d == null) continue;
                list.add(d);
            }
        }
        if (list.isEmpty()) {
            return EMPTY_VALUE;
        }
        return new CompositeDeserializer(list.toArray(new ClickHouseDeserializer[0]));
    }

    public static ClickHouseDeserializer of(List<ClickHouseDeserializer> list) {
        if (list == null) {
            return EMPTY_VALUE;
        }
        Iterator<ClickHouseDeserializer> it = list.iterator();
        while (it.hasNext()) {
            ClickHouseDeserializer d = it.next();
            if (d != null) continue;
            it.remove();
        }
        return list.isEmpty() ? EMPTY_VALUE : new CompositeDeserializer(list.toArray(new ClickHouseDeserializer[0]));
    }

    public ClickHouseValue deserialize(ClickHouseValue var1, ClickHouseInputStream var2) throws IOException;

    public static class CompositeDeserializer
    implements ClickHouseDeserializer {
        protected final ClickHouseDeserializer[] deserializers;

        protected CompositeDeserializer(ClickHouseDeserializer[] deserializers) {
            this.deserializers = deserializers;
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            ClickHouseValue v = null;
            int len = this.deserializers.length;
            for (int i = 0; i < len && (v = this.deserializers[i].deserialize(ref, input)) == null; ++i) {
            }
            return v;
        }
    }
}

