/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.feishu;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xiaomi.data.push.client.HttpClientV2;
import com.xiaomi.youpin.feishu.GsonFactory;
import com.xiaomi.youpin.feishu.bo.EmailQueryResult;
import com.xiaomi.youpin.feishu.bo.GroupPageData;
import com.xiaomi.youpin.feishu.bo.MsgBatchSendRequest;
import com.xiaomi.youpin.feishu.bo.MsgDetail;
import com.xiaomi.youpin.feishu.bo.MsgSendRequest;
import com.xiaomi.youpin.feishu.bo.Result;
import com.xiaomi.youpin.feishu.bo.TokenRequest;
import com.xiaomi.youpin.feishu.bo.TokenResult;
import com.xiaomi.youpin.feishu.bo.UserIdInfo;
import com.xiaomi.youpin.feishu.bo.UserInfoWrapperResult;
import com.xiaomi.youpin.feishu.enums.MsgTypeEnum;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FeiShu {
    private static final Logger log = LoggerFactory.getLogger(FeiShu.class);
    private String appId;
    private String appSecret;
    private AtomicReference<TokenResult> tr = new AtomicReference();
    private String CommonHead = "https://open.f.mioffice.cn";
    private String getTokenUrl = this.CommonHead + "/open-apis/auth/v3/tenant_access_token/internal/";
    private String getGroupsUrl = this.CommonHead + "/open-apis/chat/v4/list";
    private String sendMsgUrl = this.CommonHead + "/open-apis/message/v4/send/";
    private String sendBatchMsgUrl = this.CommonHead + "/open-apis/message/v4/batch_send/";
    private String getUserIdUrl = this.CommonHead + "/open-apis/user/v1/batch_get_id?emails=";
    private String cardUpdate = this.CommonHead + "/open-apis/interactive/v1/card/update";
    private String getBatchUserInfoUrl = this.CommonHead + "/open-apis/contact/v1/user/batch_get?";

    public FeiShu(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.rereshToken();
    }

    public FeiShu(String appId, String appSecret, String getTokenUrl, String getGroupsUrl, String sendMsgUrl, String sendBatchMsgUrl, String getUserIdUrl) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.getTokenUrl = getTokenUrl;
        this.getGroupsUrl = getGroupsUrl;
        this.sendMsgUrl = sendMsgUrl;
        this.sendBatchMsgUrl = sendBatchMsgUrl;
        this.getUserIdUrl = getUserIdUrl;
        this.rereshToken();
    }

    private void rereshToken() {
        try {
            TokenResult tokenResult = this.getTokenResult();
            if (tokenResult == null) {
                log.error("get token failed");
            }
            tokenResult.setUtime(System.currentTimeMillis());
            this.tr.set(tokenResult);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
        }
    }

    private String getToken() {
        TokenResult token = this.tr.get();
        long now = System.currentTimeMillis();
        if (token == null || now - token.getUtime() >= TimeUnit.SECONDS.toMillis(token.getExpire() - 5L)) {
            this.rereshToken();
        }
        return this.tr.get().getTenant_access_token();
    }

    private TokenResult getTokenResult() {
        TokenRequest request = new TokenRequest();
        request.setApp_id(this.appId);
        request.setApp_secret(this.appSecret);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        String tokenResult = HttpClientV2.post((String)this.getTokenUrl, (String)new Gson().toJson((Object)request), headers);
        TokenResult token = null;
        try {
            token = (TokenResult)new Gson().fromJson(tokenResult, TokenResult.class);
        }
        catch (Exception e) {
            log.error("json parse error, msg:{}", (Object)e.getMessage());
        }
        return token;
    }

    public List<String> getBatchPhone(List<String> openIdSet) {
        StringBuilder param = new StringBuilder("open_ids=");
        openIdSet.stream().forEach(it -> param.append(it + "&open_ids="));
        String url = this.getBatchUserInfoUrl + String.valueOf(param);
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
        headers.put("Authorization", (CallSite)((Object)("Bearer " + this.getToken())));
        String strResult = HttpClientV2.get((String)url, headers, (int)2000);
        Result result = null;
        try {
            result = (Result)new Gson().fromJson(strResult, new TypeToken<Result<UserInfoWrapperResult>>(this){}.getType());
        }
        catch (Exception e) {
            log.error("json parse error, result:{}, msg:{}", (Object)strResult, (Object)e.getMessage());
        }
        return ((UserInfoWrapperResult)result.getData()).getUser_infos().stream().map(it -> it.getMobile()).collect(Collectors.toList());
    }

    public UserIdInfo getUserIdInfoByEmail(String email) {
        if (StringUtils.isEmpty((Object)email)) {
            log.error("email error");
            return null;
        }
        String url = this.getUserIdUrl + email;
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
        headers.put("Authorization", (CallSite)((Object)("Bearer " + this.getToken())));
        String strResult = HttpClientV2.get((String)url, headers, (int)2000);
        Result result = null;
        try {
            result = (Result)new Gson().fromJson(strResult, new TypeToken<Result<EmailQueryResult>>(this){}.getType());
        }
        catch (Exception e) {
            log.error("json parse error, msg:{}", (Object)e.getMessage());
        }
        if (result == null || result.getCode() != 0 || result.getData() == null) {
            return null;
        }
        EmailQueryResult queryResult = (EmailQueryResult)result.getData();
        if (CollectionUtils.isEmpty(queryResult.getEmail_users())) {
            return null;
        }
        List<UserIdInfo> userIdInfos = queryResult.getEmail_users().get(email);
        if (CollectionUtils.isEmpty(userIdInfos)) {
            return null;
        }
        return userIdInfos.get(0);
    }

    public String getOpenIdIdByEmail(String email) {
        UserIdInfo userIdInfo = this.getUserIdInfoByEmail(email);
        return userIdInfo == null ? "" : userIdInfo.getOpen_id();
    }

    public String getUserIdByEmail(String email) {
        UserIdInfo userIdInfo = this.getUserIdInfoByEmail(email);
        return userIdInfo == null ? "" : userIdInfo.getUser_id();
    }

    public Result<GroupPageData> getGroupListByPage(String pageSize, String pageToken) {
        Object url = this.getGroupsUrl;
        boolean isPageSizeExist = false;
        if (!StringUtils.isEmpty((Object)pageSize)) {
            isPageSizeExist = true;
            url = (String)url + "?page_size=" + pageSize;
        }
        if (!StringUtils.isEmpty((Object)pageToken)) {
            url = (String)url + (isPageSizeExist ? "&" : "?") + "page_token=" + pageToken;
        }
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
        headers.put("Authorization", (CallSite)((Object)("Bearer " + this.getToken())));
        Result result = null;
        try {
            String response = HttpClientV2.get((String)url, headers, (int)3000);
            if (StringUtils.isEmpty((Object)response)) {
                log.error("response is empty");
                return null;
            }
            result = (Result)new Gson().fromJson(response, new TypeToken<Result<GroupPageData>>(this){}.getType());
        }
        catch (Exception e) {
            log.error("feishu get group list error, msg:{}", (Object)e.getMessage());
        }
        return result;
    }

    public Result<GroupPageData> getGroupList() {
        return this.getGroupListByPage(null, null);
    }

    private boolean sendMsg(String openId, String chatId, String rootId, String userId, String email, MsgTypeEnum type, String content) {
        if (type == null || StringUtils.isEmpty((Object)content)) {
            log.error("type and content can not be null, params: type:{}, content:{}", (Object)type, (Object)content);
            return false;
        }
        MsgSendRequest request = new MsgSendRequest();
        request.setMsg_type(type.getName());
        if (!StringUtils.isEmpty((Object)openId)) {
            request.setOpen_id(openId);
        }
        if (!StringUtils.isEmpty((Object)chatId)) {
            request.setChat_id(chatId);
        }
        if (!StringUtils.isEmpty((Object)rootId)) {
            request.setRoot_id(rootId);
        }
        if (!StringUtils.isEmpty((Object)userId)) {
            request.setUser_id(userId);
        }
        if (!StringUtils.isEmpty((Object)email)) {
            request.setEmail(email);
        }
        MsgDetail detail = new MsgDetail();
        switch (type) {
            case TEXT: {
                detail.setText(content);
                request.setContent(detail);
                break;
            }
            case IMAGE: {
                detail.setImage_key(content);
                request.setContent(detail);
                break;
            }
            case CARD: {
                request.setCard((Map)GsonFactory.getGson().fromJson(content, Map.class));
            }
        }
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authorization", "Bearer " + this.getToken());
        headers.put("content-type", "application/json");
        Result result = null;
        try {
            String response = HttpClientV2.post((String)this.sendMsgUrl, (String)new String(new Gson().toJson((Object)request).getBytes(), StandardCharsets.UTF_8), headers, (int)2000);
            if (StringUtils.isEmpty((Object)response)) {
                log.error("http post error when send msg, response:{}", (Object)response);
                return false;
            }
            result = (Result)new Gson().fromJson(response, Result.class);
            if (!Objects.equals(0, result.getCode())) {
                log.error("http post fail when send msg, response:{}", (Object)response);
                return false;
            }
        }
        catch (Exception e) {
            log.error("feishu send msg error:{}", (Object)e.getMessage());
            return false;
        }
        return result != null && result.getCode() == 0;
    }

    public boolean updateCard(String body) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authorization", "Bearer " + this.getToken());
        headers.put("content-type", "application/json");
        String response = HttpClientV2.post((String)this.cardUpdate, (String)body, headers, (int)2000);
        return true;
    }

    public boolean batchSendMsg(MsgBatchSendRequest batchSendRequest) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authorization", "Bearer " + this.getToken());
        headers.put("content-type", "application/json");
        Result result = null;
        try {
            String response = HttpClientV2.post((String)this.sendBatchMsgUrl, (String)new Gson().toJson((Object)batchSendRequest), headers, (int)2000);
            if (StringUtils.isEmpty((Object)response)) {
                log.error("http post error when send msg, response:{}", (Object)response);
                return false;
            }
            result = (Result)new Gson().fromJson(response, Result.class);
        }
        catch (Exception e) {
            log.error("feishu send msg error:{}", (Object)e.getMessage());
            return false;
        }
        return result != null && result.getCode() == 0;
    }

    public boolean sendMsgByEmail(String email, String content) {
        return this.sendMsg(null, null, null, null, email, MsgTypeEnum.TEXT, content);
    }

    public boolean sendCardByEmail(String email, String content) {
        return this.sendMsg(null, null, null, null, email, MsgTypeEnum.CARD, content);
    }

    public boolean sendMsgByChatId(String chatId, String content) {
        return this.sendMsg(null, chatId, null, null, null, MsgTypeEnum.TEXT, content);
    }

    public boolean sendCardByChatId(String chatId, String card) {
        return this.sendMsg(null, chatId, null, null, null, MsgTypeEnum.CARD, card);
    }

    public boolean sendMsgByUserId(String userId, String content) {
        return this.sendMsg(null, null, null, userId, null, MsgTypeEnum.TEXT, content);
    }

    public boolean sendCardByUserId(String userId, String card) {
        return this.sendMsg(null, null, null, userId, null, MsgTypeEnum.CARD, card);
    }

    public boolean sendMsgByOpenId(String openId, String content) {
        return this.sendMsg(openId, null, null, null, null, MsgTypeEnum.TEXT, content);
    }

    public boolean sendCardByOpenId(String openId, String card) {
        return this.sendMsg(openId, null, null, null, null, MsgTypeEnum.CARD, card);
    }
}

