/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.parse.AbstractLogParser;
import org.apache.ozhera.log.parse.LogParserData;
import org.apache.ozhera.log.utils.IndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLogParser
extends AbstractLogParser {
    private static final Logger log = LoggerFactory.getLogger(CustomLogParser.class);
    private boolean isParsePattern;
    private Map<Integer, List<String>> mapPattern;
    private Gson gson = new Gson();
    private String keyValueList;
    private List<String> logPerComments;

    public CustomLogParser(LogParserData parserData) {
        super(parserData);
    }

    @Override
    public Map<String, Object> doParse(String logData, String ip, Long lineNum, Long collectStamp, String fileName) {
        return this.doParseSimple(logData, collectStamp);
    }

    @Override
    public Map<String, Object> doParseSimple(String logData, Long collectStamp) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String originData = logData;
        if (logData == null) {
            return null;
        }
        try {
            if (!this.isParsePattern) {
                this.parsePatter(this.parserData.getParseScript());
            }
            if (logData.length() == 0) {
                return ret;
            }
            String originLog = logData;
            if (StringUtils.isBlank((CharSequence)this.keyValueList) && CollectionUtil.isEmpty(this.logPerComments)) {
                ret.put("message", logData);
                return ret;
            }
            List<String> logDataArray = this.parseLogData(logData);
            for (int i = 0; i < this.logPerComments.size(); ++i) {
                String value;
                if (i >= logDataArray.size()) {
                    ret.put(this.logPerComments.get(i), "");
                    continue;
                }
                ret.put(this.logPerComments.get(i), StringUtils.isNotEmpty((CharSequence)(value = logDataArray.get(i))) ? value.trim() : value);
            }
            if (ret.values().stream().map(String::valueOf).anyMatch(StringUtils::isEmpty)) {
                ret.put("logsource", originLog);
            }
            if (ret.containsKey("timestamp")) {
                Long time = this.getTimestampFromString(ret.get("timestamp").toString(), collectStamp);
                ret.put("timestamp", time);
            }
        }
        catch (Exception e) {
            ret.put("logsource", originData);
        }
        return ret;
    }

    @Override
    public List<String> parseLogData(String logData) throws Exception {
        this.parsePatter(this.parserData.getParseScript());
        ArrayList<String> parsedLogs = new ArrayList<String>();
        for (int i = 0; i < this.mapPattern.size(); ++i) {
            String parsedData = "";
            List<String> list = this.mapPattern.get(i);
            parsedData = StringUtils.isNotEmpty((CharSequence)list.get(0)) && StringUtils.isNotEmpty((CharSequence)list.get(1)) ? StringUtils.substringBetween((String)logData, (String)list.get(0), (String)list.get(1)) : (i + 1 < this.mapPattern.size() && StringUtils.isNotEmpty((CharSequence)this.mapPattern.get(i + 1).get(0)) ? StringUtils.substringBetween((String)logData, (String)"", (String)this.mapPattern.get(i + 1).get(0)) : logData);
            if (null == parsedData) break;
            parsedLogs.add(parsedData.trim());
            logData = StrUtil.removePrefix((CharSequence)logData.trim(), (CharSequence)String.format("%s%s%s", list.get(0), parsedData, list.get(1)).trim());
        }
        return parsedLogs;
    }

    public void parsePatter(String pattern) {
        this.mapPattern = new HashMap<Integer, List<String>>();
        String[] split = StringUtils.split((String)pattern, (String)"-");
        for (int i = 0; i < split.length; ++i) {
            String[] split1 = split[i].split("%s");
            if (split1.length == 2) {
                this.mapPattern.put(i, Arrays.asList(split1[0], split1[1]));
                continue;
            }
            this.mapPattern.put(i, Arrays.asList("", ""));
        }
        this.keyValueList = IndexUtils.getKeyValueList(this.parserData.getKeyList(), this.parserData.getValueList());
        this.logPerComments = Arrays.stream(StringUtils.split((String)this.keyValueList, (String)",")).collect(Collectors.toList());
        this.isParsePattern = true;
    }

    public boolean isParsePattern() {
        return this.isParsePattern;
    }

    public Map<Integer, List<String>> getMapPattern() {
        return this.mapPattern;
    }

    public Gson getGson() {
        return this.gson;
    }

    public String getKeyValueList() {
        return this.keyValueList;
    }

    public List<String> getLogPerComments() {
        return this.logPerComments;
    }

    public void setParsePattern(boolean isParsePattern) {
        this.isParsePattern = isParsePattern;
    }

    public void setMapPattern(Map<Integer, List<String>> mapPattern) {
        this.mapPattern = mapPattern;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public void setKeyValueList(String keyValueList) {
        this.keyValueList = keyValueList;
    }

    public void setLogPerComments(List<String> logPerComments) {
        this.logPerComments = logPerComments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomLogParser)) {
            return false;
        }
        CustomLogParser other = (CustomLogParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isParsePattern() != other.isParsePattern()) {
            return false;
        }
        Map<Integer, List<String>> this$mapPattern = this.getMapPattern();
        Map<Integer, List<String>> other$mapPattern = other.getMapPattern();
        if (this$mapPattern == null ? other$mapPattern != null : !((Object)this$mapPattern).equals(other$mapPattern)) {
            return false;
        }
        Gson this$gson = this.getGson();
        Gson other$gson = other.getGson();
        if (this$gson == null ? other$gson != null : !this$gson.equals(other$gson)) {
            return false;
        }
        String this$keyValueList = this.getKeyValueList();
        String other$keyValueList = other.getKeyValueList();
        if (this$keyValueList == null ? other$keyValueList != null : !this$keyValueList.equals(other$keyValueList)) {
            return false;
        }
        List<String> this$logPerComments = this.getLogPerComments();
        List<String> other$logPerComments = other.getLogPerComments();
        return !(this$logPerComments == null ? other$logPerComments != null : !((Object)this$logPerComments).equals(other$logPerComments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomLogParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isParsePattern() ? 79 : 97);
        Map<Integer, List<String>> $mapPattern = this.getMapPattern();
        result = result * 59 + ($mapPattern == null ? 43 : ((Object)$mapPattern).hashCode());
        Gson $gson = this.getGson();
        result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
        String $keyValueList = this.getKeyValueList();
        result = result * 59 + ($keyValueList == null ? 43 : $keyValueList.hashCode());
        List<String> $logPerComments = this.getLogPerComments();
        result = result * 59 + ($logPerComments == null ? 43 : ((Object)$logPerComments).hashCode());
        return result;
    }

    public String toString() {
        return "CustomLogParser(isParsePattern=" + this.isParsePattern() + ", mapPattern=" + String.valueOf(this.getMapPattern()) + ", gson=" + String.valueOf(this.getGson()) + ", keyValueList=" + this.getKeyValueList() + ", logPerComments=" + String.valueOf(this.getLogPerComments()) + ")";
    }
}

