/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.util;

import com.xiaomi.mone.tpc.login.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.mone.tpc.login.vo.MoneTpcContext;
import org.apache.commons.lang3.StringUtils;

public class UserUtil {
    private static final ThreadLocal<AuthUserVo> local = new ThreadLocal();

    public static void setUser(AuthUserVo user) {
        if (user == null) {
            return;
        }
        local.set(user);
    }

    public static final AuthUserVo getUser() {
        return local.get();
    }

    public static final MoneTpcContext getContext() {
        AuthUserVo userVo = UserUtil.getUser();
        if (userVo == null) {
            return null;
        }
        MoneTpcContext context = new MoneTpcContext();
        context.setAccount(userVo.getAccount());
        context.setUserType(userVo.getUserType());
        return context;
    }

    public static void clearUser() {
        local.remove();
    }

    public static String getFullAccount(String acc, Integer uType) {
        if (UserTypeEnum.CAS_TYPE.getCode().equals(uType)) {
            return acc;
        }
        StringBuilder fullAccount = new StringBuilder();
        fullAccount.append(acc).append("#").append(uType);
        return fullAccount.toString();
    }

    public static AuthUserVo parseFullAccount(String fullAccount) {
        if (StringUtils.isEmpty((CharSequence)fullAccount)) {
            return null;
        }
        AuthUserVo param = new AuthUserVo();
        int pos = fullAccount.lastIndexOf(35);
        if (pos <= 0) {
            param.setAccount(fullAccount);
            param.setUserType(UserTypeEnum.CAS_TYPE.getCode());
            return param;
        }
        Integer userType = Integer.parseInt(fullAccount.substring(pos + 1));
        param.setAccount(fullAccount.substring(0, pos));
        param.setUserType(userType);
        return param;
    }
}

