/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.spring.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.spring.util.DubboAnnotationUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ServiceBeanNameBuilder {
    private static final String SEPARATOR = ":";
    private final String interfaceClassName;
    private final Environment environment;
    private String version;
    private String group;

    private ServiceBeanNameBuilder(Class<?> interfaceClass, Environment environment) {
        this(interfaceClass.getName(), environment);
    }

    private ServiceBeanNameBuilder(String interfaceClassName, Environment environment) {
        this.interfaceClassName = interfaceClassName;
        this.environment = environment;
    }

    private ServiceBeanNameBuilder(AnnotationAttributes attributes, Class<?> defaultInterfaceClass, Environment environment) {
        this(DubboAnnotationUtils.resolveInterfaceName(attributes, defaultInterfaceClass), environment);
        this.group((String)AnnotationUtils.getAttribute((Map)attributes, (String)"group"));
        this.version((String)AnnotationUtils.getAttribute((Map)attributes, (String)"version"));
    }

    public static ServiceBeanNameBuilder create(AnnotationAttributes attributes, Class<?> defaultInterfaceClass, Environment environment) {
        return new ServiceBeanNameBuilder(attributes, defaultInterfaceClass, environment);
    }

    public static ServiceBeanNameBuilder create(Class<?> interfaceClass, Environment environment) {
        return new ServiceBeanNameBuilder(interfaceClass, environment);
    }

    public static ServiceBeanNameBuilder create(Service service, Class<?> interfaceClass, Environment environment) {
        return ServiceBeanNameBuilder.create(org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes((Annotation)service, (boolean)false, (boolean)false), interfaceClass, environment);
    }

    public static ServiceBeanNameBuilder create(Reference reference, Class<?> interfaceClass, Environment environment) {
        return ServiceBeanNameBuilder.create(org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes((Annotation)reference, (boolean)false, (boolean)false), interfaceClass, environment);
    }

    private static void append(StringBuilder builder, String value) {
        if (StringUtils.hasText((String)value)) {
            builder.append(SEPARATOR).append(value);
        }
    }

    public ServiceBeanNameBuilder group(String group) {
        this.group = group;
        return this;
    }

    public ServiceBeanNameBuilder version(String version) {
        this.version = version;
        return this;
    }

    public String build() {
        StringBuilder beanNameBuilder = new StringBuilder("ServiceBean");
        ServiceBeanNameBuilder.append(beanNameBuilder, this.interfaceClassName);
        ServiceBeanNameBuilder.append(beanNameBuilder, this.version);
        ServiceBeanNameBuilder.append(beanNameBuilder, this.group);
        String rawBeanName = beanNameBuilder.toString();
        return this.environment.resolvePlaceholders(rawBeanName);
    }
}

