/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoParticipant;
import org.apache.ozhera.app.api.model.HeraAppBaseQuery;
import org.apache.ozhera.app.api.model.HeraAppRoleModel;
import org.apache.ozhera.app.api.service.HeraAppService;
import org.apache.ozhera.monitor.bo.AlertGroupParam;
import org.apache.ozhera.monitor.bo.PlatForm;
import org.apache.ozhera.monitor.bo.UserInfo;
import org.apache.ozhera.monitor.dao.HeraAppRoleDao;
import org.apache.ozhera.monitor.dao.model.HeraAppRole;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlertGroupService;
import org.apache.ozhera.monitor.service.HeraBaseInfoService;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.apache.ozhera.monitor.service.model.Area;
import org.apache.ozhera.monitor.service.model.EnvMapping;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HeraBaseInfoServiceImpl
implements HeraBaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(HeraBaseInfoServiceImpl.class);
    @Autowired
    HeraAppRoleDao heraAppRoleDao;
    @Autowired
    AlertGroupService alertGroupService;
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=HeraAppService.class, group="${dubbo.group.heraapp}", timeout=5000)
    HeraAppService hearAppService;
    @Autowired
    PlatFormTypeExtensionService platFormTypeExtensionService;

    @Override
    public Result addRole(HeraAppRoleModel model) {
        Integer integer = this.hearAppService.addRole(model);
        log.info("addRole param:{},result:{}", (Object)model.toString(), (Object)integer);
        if (integer > 0) {
            return Result.success();
        }
        return Result.fail((ErrorCode)ErrorCode.unknownError);
    }

    @Override
    public Result delRole(Integer id) {
        Integer i = this.hearAppService.delRoleById(id);
        if (i > 0) {
            return Result.success();
        }
        return Result.fail((ErrorCode)ErrorCode.unknownError);
    }

    @Override
    public Result queryRole(HeraAppRoleModel model, Integer pageNo, Integer pageCount) {
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        if (pageCount == null || pageCount < 1) {
            pageCount = 10;
        }
        Long aLong = this.hearAppService.countRole(model);
        PageData<List> pd = new PageData<List>();
        pd.setPage(pageNo);
        pd.setPageSize(pageCount);
        pd.setTotal(aLong);
        if (aLong == null || aLong.intValue() == 0) {
            log.info("\u67e5\u8be2hera app\u89d2\u8272\u6ca1\u6709\u6570\u636e\uff0cparam:{}", (Object)model.toString());
            return Result.success(pd);
        }
        List heraAppRoleModels = this.hearAppService.queryRole(model, pageNo, pageCount);
        pd.setList(heraAppRoleModels);
        return Result.success(pd);
    }

    @Override
    public String getArea(String bindId, Integer plat, String regionSign) {
        HeraAppBaseInfoModel appBaseInfo = this.getAppByBindId(bindId, plat);
        log.info("getArea#appBaseInfo :{},", (Object)appBaseInfo.toString());
        if (this.platFormTypeExtensionService.belongPlatForm(appBaseInfo.getPlatformType(), PlatForm.miCloud)) {
            String envsMap = appBaseInfo.getEnvsMap();
            if (StringUtils.isBlank((CharSequence)envsMap)) {
                return null;
            }
            EnvMapping envMapping = (EnvMapping)new Gson().fromJson(envsMap, EnvMapping.class);
            log.info("getArea# appId:{},regionSign:{}, envMapping:{}", new Object[]{bindId, regionSign, envMapping.toString()});
            if (envMapping == null || CollectionUtils.isEmpty(envMapping.getAreas())) {
                return null;
            }
            List<Area> areas = envMapping.getAreas();
            for (Area area : areas) {
                List<Region> regions = area.getRegions();
                if (CollectionUtils.isEmpty(regions)) {
                    log.info("getArea,no regions found!bindId:{}", (Object)bindId);
                    return null;
                }
                for (Region region1 : regions) {
                    if (!region1.getName().equals(regionSign)) continue;
                    return area.getName();
                }
            }
        }
        return null;
    }

    @Override
    public Result queryByParticipant(org.apache.ozhera.monitor.service.model.HeraAppBaseQuery query) {
        return this.queryByParticipantRemote(query);
    }

    @Override
    public HeraAppBaseInfoModel getById(Integer id) {
        return this.getByIdRemote(id);
    }

    @Override
    public void deleAppById(Integer id) {
        HeraAppBaseInfoModel baseInfoModel = this.getById(id);
        Integer integer = this.deleteByIdRemote(id);
        if (integer > 0) {
            log.info("deleAppById success!dataId:{}", (Object)id);
        } else {
            log.info("deleAppById fail!dataId:{}", (Object)id);
        }
        HeraAppRole role = new HeraAppRole();
        role.setAppId(baseInfoModel.getBindId());
        List<HeraAppRole> roles = this.heraAppRoleDao.query(role, 1, 1000);
        if (!CollectionUtils.isEmpty(roles)) {
            for (HeraAppRole roleTmp : roles) {
                Integer integer1 = this.heraAppRoleDao.delById(roleTmp.getId());
                if (integer1 > 0) {
                    log.info("del HeraAppRole AppById sucess!dataId:{}", (Object)id);
                    continue;
                }
                log.info("del HeraAppRole AppById fail!dataId:{}", (Object)id);
            }
        }
    }

    @Override
    public HeraAppBaseInfoModel getByBindIdAndPlat(String bindId, Integer plat) {
        HeraAppBaseInfoModel query = new HeraAppBaseInfoModel();
        query.setBindId(bindId);
        query.setPlatformType(plat);
        List<HeraAppBaseInfoModel> list = this.query(query, null, null);
        if (CollectionUtils.isEmpty(list)) {
            log.info("getByBindIdAndPlat no data found! bindId:{},plat:{}", (Object)bindId, (Object)plat);
            return null;
        }
        return list.get(0);
    }

    @Override
    public void deleAppByBindIdAndPlat(String bindId, Integer plat) {
        if (StringUtils.isBlank((CharSequence)bindId) || plat == null) {
            log.error("invalid param,bindId:{},plat:{}", (Object)bindId, (Object)plat);
            return;
        }
        HeraAppBaseInfoModel query = new HeraAppBaseInfoModel();
        query.setBindId(bindId);
        query.setPlatformType(plat);
        List<HeraAppBaseInfoModel> list = this.query(query, null, null);
        if (CollectionUtils.isEmpty(list)) {
            log.info("deleAppByBindIdAndPlat no data found! bindId:{},plat:{}", (Object)bindId, (Object)plat);
        }
        for (HeraAppBaseInfoModel baseInfo : list) {
            Integer integer = this.hearAppService.delById(baseInfo.getId());
            if (integer > 0) {
                log.info("deleAppByBindIdAndPlat success!baseInfo:{}", (Object)new Gson().toJson((Object)baseInfo));
                continue;
            }
            log.error("deleAppByBindIdAndPlat success!baseInfo:{}", (Object)new Gson().toJson((Object)baseInfo));
        }
    }

    @Override
    public HeraAppBaseInfoModel getByBindIdAndName(String bindId, String appName) {
        if (StringUtils.isBlank((CharSequence)bindId) || StringUtils.isBlank((CharSequence)appName)) {
            log.error("getByBindIdAndName invalid param,bindId:{},appName:{}", (Object)bindId, (Object)appName);
            return null;
        }
        HeraAppBaseInfoModel query = new HeraAppBaseInfoModel();
        query.setBindId(bindId);
        query.setAppName(appName);
        List<HeraAppBaseInfoModel> list = this.query(query, null, null);
        if (CollectionUtils.isEmpty(list)) {
            log.info("HeraAppBaseInfo#getByBindIdAndName no data found,bindId:{}", (Object)bindId);
            return null;
        }
        return list.get(0);
    }

    @Override
    public HeraAppBaseInfoModel getAppByBindId(String bindId, Integer platFromType) {
        if (StringUtils.isBlank((CharSequence)bindId)) {
            log.error("invalid param,bindId:{}", (Object)bindId);
            return null;
        }
        HeraAppBaseInfoModel query = new HeraAppBaseInfoModel();
        query.setBindId(bindId);
        query.setPlatformType(platFromType);
        List<HeraAppBaseInfoModel> list = this.query(query, null, null);
        if (CollectionUtils.isEmpty(list)) {
            log.info("HeraAppBaseInfo#getAppByBindId no data found,bindId:{}", (Object)bindId);
            return null;
        }
        return list.get(0);
    }

    @Override
    public Result getAppMembersByAppId(String appId, Integer platForm, String user) {
        HeraAppRole role = new HeraAppRole();
        role.setAppId(appId);
        role.setAppPlatform(platForm);
        List<HeraAppRole> roles = this.heraAppRoleDao.query(role, 1, 1000);
        log.info("HeraBaseInfoService#getAppMembersByAppId appId:{}, platForm:{},result:{}", new Object[]{appId, platForm, new Gson().toJson(roles)});
        PageData<ArrayList> pageData = new PageData<ArrayList>();
        pageData.setTotal(0L);
        if (CollectionUtils.isEmpty(roles)) {
            log.info("getAppMembersByAppId no data found!appId:{},platForm:{}", (Object)appId, (Object)platForm);
            return Result.success(pageData);
        }
        List members = roles.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getUser())).map(t1 -> t1.getUser()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(members)) {
            return Result.success(pageData);
        }
        ArrayList userList = Lists.newArrayList();
        AlertGroupParam param = new AlertGroupParam();
        param.setPage(1);
        param.setPageSize(50);
        for (String userName : members) {
            String compUser;
            param.setName(userName);
            Result<PageData<List<UserInfo>>> pageDataResult = this.alertGroupService.userSearch(user, param);
            log.info("alertGroupService#userSearch userName:{}, result:{}", (Object)userName, (Object)new Gson().toJson(pageDataResult));
            AuthUserVo userVoSearch = UserUtil.parseFullAccount((String)userName);
            String string = userVoSearch == null ? userName : (compUser = StringUtils.isBlank((CharSequence)userVoSearch.getAccount()) ? userName : userVoSearch.getAccount());
            if (((PageData)pageDataResult.getData()).getTotal().intValue() <= 0) continue;
            userList.addAll(((List)((PageData)pageDataResult.getData()).getList()).stream().filter(t -> compUser.equals(t.getName())).collect(Collectors.toList()));
        }
        pageData.setList(userList);
        pageData.setTotal(Long.valueOf(userList.size()));
        return Result.success(pageData);
    }

    @Override
    public Long count(HeraAppBaseInfoModel baseInfo) {
        return this.countRemote(baseInfo);
    }

    @Override
    public List<HeraAppBaseInfoModel> query(HeraAppBaseInfoModel baseInfo, Integer pageCount, Integer pageNum) {
        return this.queryRemote(baseInfo, pageCount, pageNum);
    }

    @Override
    public List<HeraAppBaseInfoModel> queryRemote(HeraAppBaseInfoModel baseInfo, Integer pageCount, Integer pageNum) {
        List baseInfoModels = this.hearAppService.query(baseInfo, pageCount, pageNum);
        if (CollectionUtils.isEmpty((Collection)baseInfoModels)) {
            return Lists.newArrayList();
        }
        return baseInfoModels;
    }

    @Override
    public Long countRemote(HeraAppBaseInfoModel baseInfo) {
        return this.hearAppService.count(baseInfo);
    }

    @Override
    public HeraAppBaseInfoModel getByIdRemote(Integer id) {
        HeraAppBaseInfoModel baseInfoModel = this.hearAppService.getById(id);
        if (baseInfoModel == null) {
            return null;
        }
        return baseInfoModel;
    }

    @Override
    public int deleteByIdRemote(Integer id) {
        return this.hearAppService.delById(id);
    }

    @Override
    public Result queryByParticipantRemote(org.apache.ozhera.monitor.service.model.HeraAppBaseQuery query) {
        HeraAppBaseQuery queryRemote = new HeraAppBaseQuery();
        BeanUtils.copyProperties((Object)query, (Object)queryRemote);
        if (StringUtils.isBlank((CharSequence)query.getMyParticipant()) || !"yes".equals(query.getMyParticipant())) {
            query.setMyParticipant(null);
        }
        PageData pd = new PageData();
        Long aLong = this.hearAppService.countByParticipant(queryRemote);
        log.info("queryByParticipantRemote#countByParticipant count : {}", (Object)aLong);
        pd.setTotal(aLong);
        pd.setPage(query.getPage());
        pd.setPageSize(query.getPageSize());
        if (aLong != null && aLong.intValue() > 0) {
            ArrayList list = new ArrayList();
            List heraAppBaseInfoParticipants = this.hearAppService.queryByParticipant(queryRemote);
            log.info("queryByParticipantRemote#queryByParticipant result : {}", (Object)new Gson().toJson((Object)heraAppBaseInfoParticipants));
            if (!CollectionUtils.isEmpty((Collection)heraAppBaseInfoParticipants)) {
                heraAppBaseInfoParticipants.forEach(t -> {
                    HeraAppBaseInfoParticipant heraAppBaseInfoParticipant = new HeraAppBaseInfoParticipant();
                    BeanUtils.copyProperties((Object)t, (Object)heraAppBaseInfoParticipant);
                    list.add(heraAppBaseInfoParticipant);
                });
            }
            pd.setList(list);
        }
        return Result.success(pd);
    }

    @Override
    public int insertOrUpdate(HeraAppBaseInfoModel heraAppBaseInfo) {
        if (null == heraAppBaseInfo) {
            log.error("[HeraBaseInfoDao.create] null heraAppBaseInfo");
            return 0;
        }
        heraAppBaseInfo.setCreateTime(new Date());
        heraAppBaseInfo.setUpdateTime(new Date());
        heraAppBaseInfo.setStatus(Integer.valueOf(0));
        heraAppBaseInfo.setAppSignId(heraAppBaseInfo.getBindId() + "-" + heraAppBaseInfo.getPlatformType());
        try {
            int affected = this.hearAppService.insertOrUpdate(heraAppBaseInfo);
            if (affected < 1) {
                log.warn("[HeraBaseInfoDao.create] failed to insert heraAppBaseInfo: {}", (Object)heraAppBaseInfo.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[HeraBaseInfoDao.create] failed to insert heraAppBaseInfo: {}, err: {}", (Object)heraAppBaseInfo.toString(), (Object)e);
            return 0;
        }
        return 1;
    }
}

