/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocMaking;
import org.nutz.ioc.ValueProxy;
import org.nutz.ioc.ValueProxyMaker;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.meta.IocValue;
import org.nutz.ioc.val.ArrayValue;
import org.nutz.ioc.val.CollectionValue;
import org.nutz.ioc.val.EL_Value;
import org.nutz.ioc.val.EnvValue;
import org.nutz.ioc.val.FileValue;
import org.nutz.ioc.val.InnerValue;
import org.nutz.ioc.val.IocContextObjectValue;
import org.nutz.ioc.val.IocSelfValue;
import org.nutz.ioc.val.JNDI_Value;
import org.nutz.ioc.val.JavaValue;
import org.nutz.ioc.val.MapValue;
import org.nutz.ioc.val.ObjectNameValue;
import org.nutz.ioc.val.ReferTypeValue;
import org.nutz.ioc.val.ReferValue;
import org.nutz.ioc.val.StaticValue;
import org.nutz.ioc.val.SysPropValue;
import org.nutz.lang.Lang;

public class DefaultValueProxyMaker
implements ValueProxyMaker {
    @Override
    public ValueProxy make(IocMaking ing, IocValue iv) {
        Object value = iv.getValue();
        String type = iv.getType();
        if ("null".equals(type) || null == value) {
            return new StaticValue(null);
        }
        if (value instanceof ValueProxy) {
            return (ValueProxy)value;
        }
        if ("normal".equals(type) || null == type) {
            if (value.getClass().isArray()) {
                Object[] vs = (Object[])value;
                IocValue[] tmp = new IocValue[vs.length];
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = (IocValue)vs[i];
                }
                return new ArrayValue(ing, tmp);
            }
            if (value instanceof Map) {
                return new MapValue(ing, (Map)value, value.getClass());
            }
            if (value instanceof Collection) {
                return new CollectionValue(ing, (Collection)value, value.getClass());
            }
            if (value instanceof IocObject) {
                return new InnerValue((IocObject)value);
            }
            return new StaticValue(value);
        }
        if ("refer".equals(type)) {
            String s = value.toString();
            if (null != s) {
                String renm = s.toLowerCase();
                if ("$ioc".equals(renm)) {
                    return new IocSelfValue();
                }
                if ("$name".equals(renm)) {
                    return new ObjectNameValue();
                }
                if ("$context".equals(renm)) {
                    return new IocContextObjectValue();
                }
            }
            return new ReferValue(s);
        }
        if ("refer_type".equals(type)) {
            if (value instanceof CharSequence) {
                String[] tmp = value.toString().split("#");
                return new ReferTypeValue(tmp[0], Lang.forName(tmp[1], Object.class));
            }
            if (value instanceof Field) {
                return new ReferTypeValue((Field)value);
            }
            throw new IocException(ing.getObjectName(), "unspported refer_type:'%s'", value);
        }
        if ("java".equals(type)) {
            return new JavaValue(value.toString());
        }
        if ("file".equals(type)) {
            return new FileValue(value.toString());
        }
        if ("env".equals(type)) {
            return new EnvValue(value);
        }
        if ("sys".equals(type)) {
            return new SysPropValue(value);
        }
        if ("inner".equals(type)) {
            return new InnerValue((IocObject)value);
        }
        if ("jndi".equals(type)) {
            return new JNDI_Value(value.toString());
        }
        if ("el".equals(type)) {
            return new EL_Value(value.toString());
        }
        return null;
    }

    @Override
    public String[] supportedTypes() {
        return Lang.array("refer", "refer_type", "java", "env", "file", "sys", "jndi", "el");
    }
}

