/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Reference;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoParticipant;
import org.apache.ozhera.app.api.model.HeraAppBaseQuery;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.log.manager.service.HeraAppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class HeraAppServiceImpl
implements HeraAppService {
    private static final Logger log = LoggerFactory.getLogger(HeraAppServiceImpl.class);
    @Reference(interfaceClass=org.apache.ozhera.app.api.service.HeraAppService.class, group="$dubbo.env.group", check=false, timeout=5000)
    private org.apache.ozhera.app.api.service.HeraAppService heraAppService;
    private static final Cache<Long, AppBaseInfo> CACHE_LOCAL = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(3L, TimeUnit.MINUTES).build();
    private static final Cache<String, List<AppBaseInfo>> CACHE_LOCAL_IDS = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    @Override
    public List<AppBaseInfo> queryAppInfoWithLog(String appName, Integer type) {
        return this.heraAppService.queryAppInfoWithLog(appName, type);
    }

    @Override
    public List<AppBaseInfo> queryAllExistsApp() {
        return this.heraAppService.queryAllExistsApp();
    }

    @Override
    public AppBaseInfo queryById(Long id) {
        AppBaseInfo appBaseInfo = (AppBaseInfo)CACHE_LOCAL.getIfPresent((Object)id);
        if (null == appBaseInfo && null != (appBaseInfo = this.heraAppService.queryById(id))) {
            CACHE_LOCAL.put((Object)id, (Object)appBaseInfo);
        }
        return appBaseInfo;
    }

    @Override
    public List<AppBaseInfo> queryByIds(List<Long> ids) {
        String key = StringUtils.join(ids, (String)",");
        List appBaseInfos = (List)CACHE_LOCAL_IDS.getIfPresent((Object)key);
        if (CollectionUtils.isEmpty((Collection)appBaseInfos) && CollectionUtils.isNotEmpty((Collection)(appBaseInfos = this.heraAppService.queryByIds(ids)))) {
            CACHE_LOCAL_IDS.put((Object)key, (Object)appBaseInfos);
        }
        return appBaseInfos;
    }

    @Override
    public AppBaseInfo queryByAppId(Long appId, Integer type) {
        return this.heraAppService.queryByAppId(appId, type);
    }

    @Override
    public AppBaseInfo queryByAppIdPlatFormType(String bindId, Integer platformTypeCode) {
        return this.heraAppService.queryByAppIdPlatFormType(bindId, platformTypeCode);
    }

    @Override
    public AppBaseInfo queryByIamTreeId(Long iamTreeId, String bingId, Integer platformType) {
        return this.heraAppService.queryByIamTreeId(iamTreeId, bingId, platformType);
    }

    @Override
    public Long countByParticipant(HeraAppBaseQuery query) {
        return this.heraAppService.countByParticipant(query);
    }

    @Override
    public List<HeraAppBaseInfoParticipant> queryByParticipant(HeraAppBaseQuery query) {
        return this.heraAppService.queryByParticipant(query);
    }

    @Override
    public Long count(HeraAppBaseInfoModel baseInfo) {
        return this.heraAppService.count(baseInfo);
    }

    @Override
    public List<HeraAppBaseInfoModel> query(HeraAppBaseInfoModel baseInfo, Integer pageCount, Integer pageNum) {
        return this.heraAppService.query(baseInfo, pageCount, pageNum);
    }

    @Override
    public HeraAppBaseInfoModel getById(Integer id) {
        return this.heraAppService.getById(id);
    }

    @Override
    public int delById(Integer id) {
        return this.heraAppService.delById(id);
    }

    @Override
    public Long getAppCount() {
        return this.heraAppService.getAppCount();
    }
}

