/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.dao.mapper.HeraAppRoleMapper;
import org.apache.ozhera.app.model.HeraAppRole;
import org.apache.ozhera.app.model.HeraAppRoleExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class HeraAppRoleDao {
    private static final Logger log = LoggerFactory.getLogger(HeraAppRoleDao.class);
    @Resource
    private HeraAppRoleMapper heraAppRoleMapper;

    public Integer delById(Integer id) {
        if (id == null) {
            log.error("HeraAppRoleDao.delById invalid param,id is null");
        }
        try {
            return this.heraAppRoleMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            log.error("HeraAppRoleDao.delById error!{}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    public Long count(HeraAppRole heraAppRole) {
        HeraAppRoleExample example = new HeraAppRoleExample();
        HeraAppRoleExample.Criteria ca = example.createCriteria().andStatusEqualTo(0);
        if (heraAppRole.getStatus() != null) {
            ca.andStatusEqualTo(heraAppRole.getStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)heraAppRole.getAppId())) {
            ca.andAppIdEqualTo(heraAppRole.getAppId());
        }
        if (heraAppRole.getAppPlatform() != null) {
            ca.andAppPlatformEqualTo(heraAppRole.getAppPlatform());
        }
        if (StringUtils.isNotEmpty((CharSequence)heraAppRole.getUser())) {
            ca.andUserEqualTo(heraAppRole.getUser());
        }
        if (heraAppRole.getRole() != null) {
            ca.andRoleEqualTo(heraAppRole.getRole());
        }
        try {
            return this.heraAppRoleMapper.countByExample(example);
        }
        catch (Exception e) {
            log.error("HeraAppRoleDao#count error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<HeraAppRole> query(HeraAppRole heraAppRole, Integer pageCount, Integer pageNum) {
        if (pageCount == null || pageCount <= 0) {
            pageCount = 1;
        }
        if (pageNum == null || pageNum <= 0) {
            pageNum = 10;
        }
        HeraAppRoleExample example = new HeraAppRoleExample();
        HeraAppRoleExample.Criteria ca = example.createCriteria().andStatusEqualTo(0);
        if (heraAppRole.getStatus() != null) {
            ca.andStatusEqualTo(heraAppRole.getStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)heraAppRole.getAppId())) {
            ca.andAppIdEqualTo(heraAppRole.getAppId());
        }
        if (heraAppRole.getAppPlatform() != null) {
            ca.andAppPlatformEqualTo(heraAppRole.getAppPlatform());
        }
        if (StringUtils.isNotEmpty((CharSequence)heraAppRole.getUser())) {
            ca.andUserEqualTo(heraAppRole.getUser());
        }
        if (heraAppRole.getRole() != null) {
            ca.andRoleEqualTo(heraAppRole.getRole());
        }
        example.setOffset((pageCount - 1) * pageNum);
        example.setLimit(pageNum);
        try {
            return this.heraAppRoleMapper.selectByExample(example);
        }
        catch (Exception e) {
            log.error("HeraAppRoleDao#query error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<HeraAppRole> queryByPlatTypes(String appId, List<Integer> platTypes, Integer pageCount, Integer pageNum) {
        if (pageCount == null || pageCount <= 0) {
            pageCount = 1;
        }
        if (pageNum == null || pageNum <= 0) {
            pageNum = 10;
        }
        HeraAppRoleExample example = new HeraAppRoleExample();
        for (Integer platForm : platTypes) {
            HeraAppRoleExample.Criteria ca = example.createCriteria().andStatusEqualTo(0);
            ca.andAppIdEqualTo(appId);
            ca.andAppPlatformEqualTo(platForm);
            example.or(ca);
        }
        example.setOffset((pageCount - 1) * pageNum);
        example.setLimit(pageNum);
        try {
            return this.heraAppRoleMapper.selectByExample(example);
        }
        catch (Exception e) {
            log.error("HeraAppRoleDao#queryByPlatTypes error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int create(HeraAppRole heraAppRole) {
        if (null == heraAppRole) {
            log.error("[HeraAppRoleDao.create] null heraAppRole");
            return 0;
        }
        heraAppRole.setCreateTime(new Date());
        heraAppRole.setUpdateTime(new Date());
        heraAppRole.setStatus(0);
        try {
            int affected = this.heraAppRoleMapper.insert(heraAppRole);
            if (affected < 1) {
                log.warn("[HeraAppRoleDao.create] failed to insert heraAppRole: {}", (Object)heraAppRole.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[HeraAppRoleDao.create] failed to insert heraAppRole: {}, err: {}", (Object)heraAppRole.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public int batchCreate(List<HeraAppRole> heraAppRoles) {
        if (CollectionUtils.isEmpty(heraAppRoles)) {
            log.error("[HeraAppRoleDao.batchCreate] null heraAppRoles");
            return 0;
        }
        heraAppRoles.forEach(heraAppRole -> {
            heraAppRole.setCreateTime(new Date());
            heraAppRole.setUpdateTime(new Date());
            heraAppRole.setStatus(0);
        });
        try {
            int affected = this.heraAppRoleMapper.batchInsert(heraAppRoles);
            if (affected < 1) {
                log.warn("[HeraAppRoleDao.batchCreate] failed to insert heraAppRoles: {}", heraAppRoles);
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[HeraAppRoleDao.batchCreate] failed to insert heraAppRoles: {}, err: {}", heraAppRoles, (Object)e);
            return 0;
        }
        return 1;
    }

    public int update(HeraAppRole heraAppRole) {
        if (null == heraAppRole) {
            log.error("[HeraAppRoleDao.update] null heraAppRole");
            return 0;
        }
        heraAppRole.setUpdateTime(new Date());
        try {
            int affected = this.heraAppRoleMapper.updateByPrimaryKey(heraAppRole);
            if (affected < 1) {
                log.warn("[HeraAppRoleDao.update] failed to update heraAppRole: {}", (Object)heraAppRole.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[HeraAppRoleDao.update] failed to update heraAppRole: {}, err: {}", (Object)heraAppRole.toString(), (Object)e);
            return 0;
        }
        return 1;
    }
}

