/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.fury;

import org.apache.fury.ThreadSafeFury;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.serializer.fury.FurySerializerFactory;

@LoadLevel(name="FURY")
public class FurySerializer
implements Serializer {
    public <T> byte[] serialize(T t) {
        if (!(t instanceof AbstractMessage)) {
            throw new IllegalArgumentException("AbstractMessage isn't available.");
        }
        ThreadSafeFury threadSafeFury = FurySerializerFactory.getInstance().get();
        return threadSafeFury.serialize(t);
    }

    public <T> T deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes is null");
        }
        ThreadSafeFury threadSafeFury = FurySerializerFactory.getInstance().get();
        return (T)threadSafeFury.deserialize(bytes);
    }
}

