/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.SessionWindow;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumn;

public class SessionWindowManager
implements IWindowManager {
    private final boolean isNeedOutputEndTime;
    private boolean initialized;
    private boolean needSkip;
    private final SessionWindow sessionWindow;

    public SessionWindowManager(boolean isNeedOutputEndTime, long timeInterval, boolean ascending) {
        this.isNeedOutputEndTime = isNeedOutputEndTime;
        this.initialized = false;
        this.needSkip = false;
        this.sessionWindow = new SessionWindow(timeInterval, ascending);
    }

    @Override
    public boolean isCurWindowInit() {
        return this.initialized;
    }

    @Override
    public void initCurWindow() {
        this.initialized = true;
        this.sessionWindow.setInitializedTimeValue(false);
    }

    @Override
    public boolean hasNext(boolean hasMoreData) {
        return hasMoreData;
    }

    @Override
    public void next() {
        this.needSkip = true;
        this.initialized = false;
        this.sessionWindow.setLastTsBlockTime(0L);
    }

    @Override
    public IWindow getCurWindow() {
        return this.sessionWindow;
    }

    @Override
    public TsBlock skipPointsOutOfCurWindow(TsBlock inputTsBlock) {
        int i;
        if (!this.needSkip) {
            return inputTsBlock;
        }
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return inputTsBlock;
        }
        TimeColumn timeColumn = inputTsBlock.getTimeColumn();
        int size = inputTsBlock.getPositionCount();
        long previousTimeValue = this.sessionWindow.getTimeValue();
        for (i = 0; i < size; ++i) {
            long currentTime = timeColumn.getLong(i);
            if (Math.abs(currentTime - previousTimeValue) > this.sessionWindow.getTimeInterval()) {
                this.sessionWindow.setTimeValue(previousTimeValue);
                break;
            }
            if (this.sessionWindow.getStartTime() > currentTime) {
                this.sessionWindow.setStartTime(currentTime);
            }
            if (this.sessionWindow.getEndTime() < currentTime) {
                this.sessionWindow.setEndTime(currentTime);
            }
            previousTimeValue = currentTime;
        }
        if (i < size) {
            this.needSkip = false;
        }
        return inputTsBlock.subTsBlock(i);
    }

    @Override
    public boolean satisfiedCurWindow(TsBlock inputTsBlock) {
        return true;
    }

    @Override
    public boolean isTsBlockOutOfBound(TsBlock inputTsBlock) {
        return false;
    }

    @Override
    public TsBlockBuilder createResultTsBlockBuilder(List<Aggregator> aggregators) {
        List<TSDataType> dataTypes = this.getResultDataTypes(aggregators);
        if (this.isNeedOutputEndTime) {
            dataTypes.add(0, TSDataType.INT64);
        }
        return new TsBlockBuilder(dataTypes);
    }

    @Override
    public void appendAggregationResult(TsBlockBuilder resultTsBlockBuilder, List<Aggregator> aggregators) {
        long endTime = this.isNeedOutputEndTime ? this.sessionWindow.getEndTime() : -1L;
        this.outputAggregators(aggregators, resultTsBlockBuilder, this.sessionWindow.getStartTime(), endTime);
    }

    @Override
    public boolean needSkipInAdvance() {
        return this.isNeedOutputEndTime;
    }

    @Override
    public boolean isIgnoringNull() {
        return false;
    }
}

