/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.ArrayList;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFMinMax
implements UDTF {
    ArrayList<Double> value = new ArrayList();
    ArrayList<Long> timestamp = new ArrayList();
    static final String BATCH_COMPUTE = "batch";
    static final String STREAM_COMPUTE = "stream";
    String compute = "batch";
    double min = 0.0;
    double max = 0.0;
    boolean flag = true;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(x -> ((String)x).equalsIgnoreCase(BATCH_COMPUTE) || ((String)x).equalsIgnoreCase(STREAM_COMPUTE), "Parameter \"compute\" is illegal. Please use \"batch\" (for default) or \"stream\".", (Object)validator.getParameters().getStringOrDefault("compute", BATCH_COMPUTE)).validate(params -> (Double)params[0] < (Double)params[1], "parameter $min$ should be smaller than $max$.", validator.getParameters().getDoubleOrDefault("min", -1.7976931348623157E308), validator.getParameters().getDoubleOrDefault("max", Double.MAX_VALUE));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.value.clear();
        this.timestamp.clear();
        this.min = 0.0;
        this.max = 0.0;
        this.flag = true;
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.compute = parameters.getStringOrDefault("compute", BATCH_COMPUTE);
        if (this.compute.equalsIgnoreCase(STREAM_COMPUTE)) {
            this.min = parameters.getDouble("min");
            this.max = parameters.getDouble("max");
        }
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (this.compute.equalsIgnoreCase(STREAM_COMPUTE) && this.max > this.min) {
            collector.putDouble(row.getTime(), (Util.getValueAsDouble(row) - this.min) / (this.max - this.min));
        } else if (this.compute.equalsIgnoreCase(BATCH_COMPUTE)) {
            double v = Util.getValueAsDouble(row);
            if (Double.isFinite(v)) {
                this.value.add(v);
            }
            this.timestamp.add(row.getTime());
            if (this.flag) {
                this.min = v;
                this.max = v;
                this.flag = false;
            } else if (v > this.max) {
                this.max = v;
            } else if (v < this.min) {
                this.min = v;
            }
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        if (this.compute.equalsIgnoreCase(BATCH_COMPUTE) && this.max > this.min) {
            for (int i = 0; i < this.value.size(); ++i) {
                collector.putDouble(this.timestamp.get(i), (this.value.get(i) - this.min) / (this.max - this.min));
            }
        }
    }
}

