/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileEpochManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileEpochManager.class);
    private static final String[] EMPTY_MEASUREMENT_ARRAY = new String[0];
    private final ConcurrentMap<String, TsFileEpoch> filePath2Epoch = new ConcurrentHashMap<String, TsFileEpoch>();

    public PipeRealtimeEvent bindPipeTsFileInsertionEvent(PipeTsFileInsertionEvent event, TsFileResource resource) {
        String filePath = resource.getTsFilePath();
        this.filePath2Epoch.computeIfAbsent(filePath, path -> {
            LOGGER.info("TsFileEpoch not found for TsFile {}, creating a new one", path);
            return new TsFileEpoch(resource);
        });
        TsFileEpoch epoch = (TsFileEpoch)this.filePath2Epoch.remove(filePath);
        LOGGER.info("All data in TsFileEpoch {} was extracted", (Object)epoch);
        return new PipeRealtimeEvent(event, epoch, resource.getDevices().stream().collect(Collectors.toMap(device -> ((PlainDeviceID)device).toStringID(), device -> EMPTY_MEASUREMENT_ARRAY)), event.getPipePattern());
    }

    public PipeRealtimeEvent bindPipeInsertNodeTabletInsertionEvent(PipeInsertNodeTabletInsertionEvent event, InsertNode node, TsFileResource resource) {
        TsFileEpoch epoch = this.filePath2Epoch.computeIfAbsent(resource.getTsFilePath(), k -> new TsFileEpoch(resource));
        epoch.updateInsertNodeMinTime(node.getMinTime());
        return new PipeRealtimeEvent(event, epoch, node instanceof InsertRowsNode ? this.getDevice2MeasurementsMapFromInsertRowsNode((InsertRowsNode)node) : Collections.singletonMap(node.getDevicePath().getFullPath(), node.getMeasurements()), event.getPipePattern());
    }

    private Map<String, String[]> getDevice2MeasurementsMapFromInsertRowsNode(InsertRowsNode insertRowsNode) {
        return insertRowsNode.getInsertRowNodeList().stream().collect(Collectors.toMap(insertRowNode -> insertRowNode.getDevicePath().getFullPath(), InsertNode::getMeasurements, (oldMeasurements, newMeasurements) -> (String[])Stream.of(Arrays.asList(oldMeasurements), Arrays.asList(newMeasurements)).flatMap(Collection::stream).distinct().toArray(String[]::new)));
    }
}

