/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;

public class RepairUnsortedFileCompactionEstimator
extends AbstractInnerSpaceEstimator {
    @Override
    protected long calculatingMetadataMemoryCost(CompactionTaskInfo taskInfo) {
        long cost = 0L;
        long maxAlignedSeriesMemCost = taskInfo.getFileInfoList().stream().mapToLong(fileInfo -> fileInfo.maxMemToReadAlignedSeries).sum();
        long maxNonAlignedSeriesMemCost = taskInfo.getFileInfoList().stream().mapToLong(fileInfo -> fileInfo.maxMemToReadNonAlignedSeries * (long)this.config.getSubCompactionTaskNum()).sum();
        cost += Math.min(Math.max(maxAlignedSeriesMemCost, maxNonAlignedSeriesMemCost), (long)(taskInfo.getFileInfoList().size() * taskInfo.getMaxChunkMetadataNumInDevice()) * taskInfo.getMaxChunkMetadataSize());
        long sizeForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
        return cost += sizeForFileWriter;
    }

    @Override
    protected long calculatingDataMemoryCost(CompactionTaskInfo taskInfo) {
        if (taskInfo.getTotalChunkNum() == 0L) {
            return taskInfo.getModificationFileSize();
        }
        long maxConcurrentSeriesNum = Math.max(this.config.getSubCompactionTaskNum(), taskInfo.getMaxConcurrentSeriesNum());
        long averageChunkSize = taskInfo.getTotalFileSize() / taskInfo.getTotalChunkNum();
        long maxConcurrentSeriesSize = averageChunkSize * maxConcurrentSeriesNum * (long)taskInfo.getMaxChunkMetadataNumInSeries() + maxConcurrentSeriesNum * (long)this.tsFileConfig.getPageSizeInByte();
        long maxTargetChunkWriterSize = this.config.getTargetChunkSize() * maxConcurrentSeriesNum;
        long targetChunkWriterSize = Math.min(maxConcurrentSeriesSize, maxTargetChunkWriterSize);
        long inMemorySortedDataSize = (averageChunkSize + (long)this.tsFileConfig.getPageSizeInByte()) * Math.min((long)taskInfo.getMaxChunkMetadataNumInDevice(), (long)taskInfo.getMaxChunkMetadataNumInSeries() * maxConcurrentSeriesNum);
        return targetChunkWriterSize + inMemorySortedDataSize + taskInfo.getModificationFileSize();
    }

    @Override
    public long roughEstimateInnerCompactionMemory(CompactionScheduleContext context, List<TsFileResource> resources) throws IOException {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public boolean supportsRoughEstimation() {
        return false;
    }
}

